/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.state;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.version.CompatibilityVersions;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClusterStateAction
extends TransportMasterNodeReadAction<ClusterStateRequest, ClusterStateResponse> {
    private static final Logger logger = LogManager.getLogger(TransportClusterStateAction.class);

    @Inject
    public TransportClusterStateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:monitor/state", false, transportService, clusterService, threadPool, actionFilters, ClusterStateRequest::new, indexNameExpressionResolver, ClusterStateResponse::new, threadPool.executor("management"));
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterStateRequest request, ClusterState state) {
        return null;
    }

    @Override
    protected void masterOperation(Task task, final ClusterStateRequest request, final ClusterState state, final ActionListener<ClusterStateResponse> listener) throws IOException {
        Predicate<ClusterState> acceptableClusterStateOrFailedPredicate;
        assert (task instanceof CancellableTask) : String.valueOf(task) + " not cancellable";
        final CancellableTask cancellableTask = (CancellableTask)task;
        final Predicate<ClusterState> acceptableClusterStatePredicate = request.waitForMetadataVersion() == null ? Predicates.always() : clusterState -> clusterState.metadata().version() >= request.waitForMetadataVersion();
        Predicate<ClusterState> predicate = acceptableClusterStateOrFailedPredicate = request.local() ? acceptableClusterStatePredicate : acceptableClusterStatePredicate.or(clusterState -> !clusterState.nodes().isLocalNodeElectedMaster());
        if (cancellableTask.notifyIfCancelled(listener)) {
            return;
        }
        if (acceptableClusterStatePredicate.test(state)) {
            ActionListener.completeWith(listener, () -> this.buildResponse(request, state));
        } else {
            assert (!acceptableClusterStateOrFailedPredicate.test(state));
            new ClusterStateObserver(state, this.clusterService, request.waitForTimeout(), logger, this.threadPool.getThreadContext()).waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState newState) {
                    if (cancellableTask.notifyIfCancelled(listener)) {
                        return;
                    }
                    if (acceptableClusterStatePredicate.test(newState)) {
                        TransportClusterStateAction.this.executor.execute(ActionRunnable.supply(listener, () -> TransportClusterStateAction.this.buildResponse(request, newState)));
                    } else {
                        listener.onFailure(new NotMasterException("master stepped down waiting for metadata version " + request.waitForMetadataVersion()));
                    }
                }

                @Override
                public void onClusterServiceClose() {
                    listener.onFailure(new NodeClosedException(TransportClusterStateAction.this.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    ActionListener.run(listener, l -> {
                        if (!cancellableTask.notifyIfCancelled(l)) {
                            l.onResponse(new ClusterStateResponse(state.getClusterName(), null, true));
                        }
                    });
                }
            }, clusterState -> cancellableTask.isCancelled() || acceptableClusterStateOrFailedPredicate.test((ClusterState)clusterState));
        }
    }

    @SuppressForbidden(reason="exposing ClusterState#compatibilityVersions requires reading them")
    private static Map<String, CompatibilityVersions> getCompatibilityVersions(ClusterState clusterState) {
        return clusterState.compatibilityVersions();
    }

    @SuppressForbidden(reason="exposing ClusterState#clusterFeatures requires reading them")
    private static Map<String, Set<String>> getClusterFeatures(ClusterState clusterState) {
        return clusterState.clusterFeatures().nodeFeatures();
    }

    private ClusterStateResponse buildResponse(ClusterStateRequest request, ClusterState currentState) {
        String[] indices;
        ClusterBlockException blockException;
        ThreadPool.assertCurrentThreadPool("management");
        if (!request.blocks() && (blockException = currentState.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ)) != null) {
            throw blockException;
        }
        logger.trace("Serving cluster state request using version {}", (Object)currentState.version());
        ClusterState.Builder builder = ClusterState.builder(currentState.getClusterName());
        builder.version(currentState.version());
        builder.stateUUID(currentState.stateUUID());
        if (request.nodes()) {
            builder.nodes(currentState.nodes());
            builder.nodeIdsToCompatibilityVersions(TransportClusterStateAction.getCompatibilityVersions(currentState));
            builder.nodeFeatures(TransportClusterStateAction.getClusterFeatures(currentState));
        }
        if (request.routingTable()) {
            if (request.indices().length > 0) {
                RoutingTable.Builder routingTableBuilder = RoutingTable.builder();
                for (String filteredIndex : indices = this.indexNameExpressionResolver.concreteIndexNames(currentState, request)) {
                    if (!currentState.routingTable().getIndicesRouting().containsKey(filteredIndex)) continue;
                    routingTableBuilder.add(currentState.routingTable().getIndicesRouting().get(filteredIndex));
                }
                builder.routingTable(routingTableBuilder.build());
            } else {
                builder.routingTable(currentState.routingTable());
            }
        }
        if (request.blocks()) {
            builder.blocks(currentState.blocks());
        }
        Metadata.Builder mdBuilder = Metadata.builder();
        mdBuilder.clusterUUID(currentState.metadata().clusterUUID());
        mdBuilder.coordinationMetadata(currentState.coordinationMetadata());
        if (request.metadata()) {
            if (request.indices().length > 0) {
                mdBuilder.version(currentState.metadata().version());
                for (String filteredIndex : indices = this.indexNameExpressionResolver.concreteIndexNames(currentState, request)) {
                    IndexAbstraction indexAbstraction = (IndexAbstraction)currentState.metadata().getIndicesLookup().get(filteredIndex);
                    if (indexAbstraction.getParentDataStream() != null) {
                        DataStream dataStream = indexAbstraction.getParentDataStream();
                        for (Index backingIndex : dataStream.getIndices()) {
                            mdBuilder.put(currentState.metadata().index(backingIndex), false);
                        }
                        mdBuilder.put(dataStream);
                        continue;
                    }
                    IndexMetadata indexMetadata = currentState.metadata().index(filteredIndex);
                    if (indexMetadata == null) continue;
                    mdBuilder.put(indexMetadata, false);
                }
            } else {
                mdBuilder = Metadata.builder(currentState.metadata());
            }
            for (Map.Entry<String, ChunkedToXContent> entry : currentState.metadata().customs().entrySet()) {
                if (((Metadata.Custom)entry.getValue()).context().contains((Object)Metadata.XContentContext.API)) continue;
                mdBuilder.removeCustom(entry.getKey());
            }
        }
        builder.metadata(mdBuilder);
        if (request.customs()) {
            for (Map.Entry<String, ChunkedToXContent> entry : currentState.customs().entrySet()) {
                if (((ClusterState.Custom)entry.getValue()).isPrivate()) continue;
                builder.putCustom(entry.getKey(), (ClusterState.Custom)entry.getValue());
            }
        }
        return new ClusterStateResponse(currentState.getClusterName(), builder.build(), false);
    }
}

