/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.concurrent.Executor;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.DeleteDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.IsolateDatafeedAction;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.datafeed.DatafeedManager;

public class TransportDeleteDatafeedAction
extends AcknowledgedTransportMasterNodeAction<DeleteDatafeedAction.Request> {
    private final Client client;
    private final DatafeedManager datafeedManager;
    private final PersistentTasksService persistentTasksService;

    @Inject
    public TransportDeleteDatafeedAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, PersistentTasksService persistentTasksService, DatafeedManager datafeedManager) {
        super("cluster:admin/xpack/ml/datafeeds/delete", transportService, clusterService, threadPool, actionFilters, DeleteDatafeedAction.Request::new, indexNameExpressionResolver, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = client;
        this.persistentTasksService = persistentTasksService;
        this.datafeedManager = datafeedManager;
    }

    protected void masterOperation(Task task, DeleteDatafeedAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        if (request.isForce()) {
            this.forceDeleteDatafeed(request, state, listener);
        } else {
            this.datafeedManager.deleteDatafeed(request, state, listener);
        }
    }

    private void forceDeleteDatafeed(DeleteDatafeedAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        IsolateDatafeedAction.Request isolateDatafeedRequest = new IsolateDatafeedAction.Request(request.getDatafeedId());
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)IsolateDatafeedAction.INSTANCE, (ActionRequest)isolateDatafeedRequest, (ActionListener)listener.delegateFailureAndWrap((l, response) -> this.datafeedManager.deleteDatafeed(request, this.clusterService.state(), (ActionListener<AcknowledgedResponse>)l)).delegateFailureAndWrap((l, response) -> this.removeDatafeedTask(request, state, (ActionListener<Boolean>)l)));
    }

    private void removeDatafeedTask(DeleteDatafeedAction.Request request, ClusterState state, final ActionListener<Boolean> listener) {
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)state.getMetadata().custom("persistent_tasks");
        PersistentTasksCustomMetadata.PersistentTask datafeedTask = MlTasks.getDatafeedTask((String)request.getDatafeedId(), (PersistentTasksCustomMetadata)tasks);
        if (datafeedTask == null) {
            listener.onResponse((Object)true);
        } else {
            this.persistentTasksService.sendRemoveRequest(datafeedTask.getId(), MachineLearning.HARD_CODED_MACHINE_LEARNING_MASTER_NODE_TIMEOUT, new ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>>(){

                public void onResponse(PersistentTasksCustomMetadata.PersistentTask<?> persistentTask) {
                    listener.onResponse((Object)Boolean.TRUE);
                }

                public void onFailure(Exception e) {
                    if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                        listener.onResponse((Object)true);
                    } else {
                        listener.onFailure(e);
                    }
                }
            });
        }
    }

    protected ClusterBlockException checkBlock(DeleteDatafeedAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

