/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.phase;

import java.lang.invoke.StringConcatFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import org.elasticsearch.core.Strings;
import org.elasticsearch.painless.AnalyzerCaster;
import org.elasticsearch.painless.Operation;
import org.elasticsearch.painless.ir.BinaryMathNode;
import org.elasticsearch.painless.ir.BooleanNode;
import org.elasticsearch.painless.ir.CastNode;
import org.elasticsearch.painless.ir.ComparisonNode;
import org.elasticsearch.painless.ir.ConstantNode;
import org.elasticsearch.painless.ir.ExpressionNode;
import org.elasticsearch.painless.ir.InvokeCallMemberNode;
import org.elasticsearch.painless.ir.NullNode;
import org.elasticsearch.painless.ir.StringConcatenationNode;
import org.elasticsearch.painless.ir.UnaryMathNode;
import org.elasticsearch.painless.lookup.PainlessCast;
import org.elasticsearch.painless.lookup.PainlessInstanceBinding;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.phase.IRExpressionModifyingVisitor;
import org.elasticsearch.painless.spi.annotation.CompileTimeOnlyAnnotation;
import org.elasticsearch.painless.symbol.IRDecorations;

public class DefaultConstantFoldingOptimizationPhase
extends IRExpressionModifyingVisitor {
    private static IllegalStateException unaryError(String type, String operation, String constant) {
        return new IllegalStateException(Strings.format((String)"constant folding error: unexpected type [%s] for unary operation [%s] on constant [%s]", (Object[])new Object[]{type, operation, constant}));
    }

    private static IllegalStateException binaryError(String type, String operation, String constant1, String constant2) {
        return DefaultConstantFoldingOptimizationPhase.error(type, "binary", operation, constant1, constant2);
    }

    private static IllegalStateException booleanError(String type, String operation, String constant1, String constant2) {
        return DefaultConstantFoldingOptimizationPhase.error(type, "boolean", operation, constant1, constant2);
    }

    private static IllegalStateException comparisonError(String type, String operation, String constant1, String constant2) {
        return DefaultConstantFoldingOptimizationPhase.error(type, "comparison", operation, constant1, constant2);
    }

    private static IllegalStateException error(String type, String opType, String operation, String constant1, String constant2) {
        return new IllegalStateException(Strings.format((String)"constant folding error: unexpected type [%s] for %s operation [%s] on constants [%s] and [%s]", (Object[])new Object[]{type, opType, operation, constant1, constant2}));
    }

    @Override
    public void visitUnaryMath(UnaryMathNode irUnaryMathNode, Consumer<ExpressionNode> scope) {
        irUnaryMathNode.getChildNode().visit(this, irUnaryMathNode::setChildNode);
        if (irUnaryMathNode.getChildNode() instanceof ConstantNode) {
            ExpressionNode irConstantNode = irUnaryMathNode.getChildNode();
            Object constantValue = irConstantNode.getDecorationValue(IRDecorations.IRDConstant.class);
            Operation operation = (Operation)((Object)irUnaryMathNode.getDecorationValue(IRDecorations.IRDOperation.class));
            Class type = (Class)irUnaryMathNode.getDecorationValue(IRDecorations.IRDExpressionType.class);
            if (operation == Operation.SUB) {
                if (type == Integer.TYPE) {
                    irConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(-((Integer)constantValue).intValue())));
                } else if (type == Long.TYPE) {
                    irConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(-((Long)constantValue).longValue())));
                } else if (type == Float.TYPE) {
                    irConstantNode.attachDecoration(new IRDecorations.IRDConstant(Float.valueOf(-((Float)constantValue).floatValue())));
                } else if (type == Double.TYPE) {
                    irConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(-((Double)constantValue).doubleValue())));
                } else {
                    throw irUnaryMathNode.getLocation().createError(DefaultConstantFoldingOptimizationPhase.unaryError(PainlessLookupUtility.typeToCanonicalTypeName(type), operation.symbol, irConstantNode.getDecorationString(IRDecorations.IRDConstant.class)));
                }
                scope.accept(irConstantNode);
            } else if (operation == Operation.BWNOT) {
                if (type == Integer.TYPE) {
                    irConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(~((Integer)constantValue).intValue())));
                } else if (type == Long.TYPE) {
                    irConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)constantValue ^ 0xFFFFFFFFFFFFFFFFL)));
                } else {
                    throw irUnaryMathNode.getLocation().createError(DefaultConstantFoldingOptimizationPhase.unaryError(PainlessLookupUtility.typeToCanonicalTypeName(type), operation.symbol, irConstantNode.getDecorationString(IRDecorations.IRDConstant.class)));
                }
                scope.accept(irConstantNode);
            } else if (operation == Operation.NOT) {
                if (type != Boolean.TYPE) {
                    throw irUnaryMathNode.getLocation().createError(DefaultConstantFoldingOptimizationPhase.unaryError(PainlessLookupUtility.typeToCanonicalTypeName(type), operation.symbol, irConstantNode.getDecorationString(IRDecorations.IRDConstant.class)));
                }
                irConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Boolean)constantValue == false ? 1 : 0)));
                scope.accept(irConstantNode);
            } else if (operation == Operation.ADD) {
                scope.accept(irConstantNode);
            }
        }
    }

    @Override
    public void visitBinaryMath(BinaryMathNode irBinaryMathNode, Consumer<ExpressionNode> scope) {
        irBinaryMathNode.getLeftNode().visit(this, irBinaryMathNode::setLeftNode);
        irBinaryMathNode.getRightNode().visit(this, irBinaryMathNode::setRightNode);
        if (irBinaryMathNode.getLeftNode() instanceof ConstantNode && irBinaryMathNode.getRightNode() instanceof ConstantNode) {
            ExpressionNode irLeftConstantNode = irBinaryMathNode.getLeftNode();
            ExpressionNode irRightConstantNode = irBinaryMathNode.getRightNode();
            Object leftConstantValue = irLeftConstantNode.getDecorationValue(IRDecorations.IRDConstant.class);
            Object rightConstantValue = irRightConstantNode.getDecorationValue(IRDecorations.IRDConstant.class);
            Operation operation = (Operation)((Object)irBinaryMathNode.getDecorationValue(IRDecorations.IRDOperation.class));
            Class type = (Class)irBinaryMathNode.getDecorationValue(IRDecorations.IRDExpressionType.class);
            if (operation == Operation.MUL) {
                if (type == Integer.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue * (Integer)rightConstantValue)));
                } else if (type == Long.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue * (Long)rightConstantValue)));
                } else if (type == Float.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant(Float.valueOf(((Float)leftConstantValue).floatValue() * ((Float)rightConstantValue).floatValue())));
                } else if (type == Double.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Double)leftConstantValue * (Double)rightConstantValue)));
                } else {
                    throw irBinaryMathNode.getLocation().createError(DefaultConstantFoldingOptimizationPhase.binaryError(PainlessLookupUtility.typeToCanonicalTypeName(type), operation.symbol, irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class), irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class)));
                }
                scope.accept(irLeftConstantNode);
            } else if (operation == Operation.DIV) {
                block84: {
                    try {
                        if (type == Integer.TYPE) {
                            irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue / (Integer)rightConstantValue)));
                            break block84;
                        }
                        if (type == Long.TYPE) {
                            irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue / (Long)rightConstantValue)));
                            break block84;
                        }
                        if (type == Float.TYPE) {
                            irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant(Float.valueOf(((Float)leftConstantValue).floatValue() / ((Float)rightConstantValue).floatValue())));
                            break block84;
                        }
                        if (type == Double.TYPE) {
                            irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Double)leftConstantValue / (Double)rightConstantValue)));
                            break block84;
                        }
                        throw irBinaryMathNode.getLocation().createError(DefaultConstantFoldingOptimizationPhase.binaryError(PainlessLookupUtility.typeToCanonicalTypeName(type), operation.symbol, irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class), irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class)));
                    }
                    catch (ArithmeticException ae) {
                        throw irBinaryMathNode.getLocation().createError(ae);
                    }
                }
                scope.accept(irLeftConstantNode);
            } else if (operation == Operation.REM) {
                block85: {
                    try {
                        if (type == Integer.TYPE) {
                            irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue % (Integer)rightConstantValue)));
                            break block85;
                        }
                        if (type == Long.TYPE) {
                            irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue % (Long)rightConstantValue)));
                            break block85;
                        }
                        if (type == Float.TYPE) {
                            irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant(Float.valueOf(((Float)leftConstantValue).floatValue() % ((Float)rightConstantValue).floatValue())));
                            break block85;
                        }
                        if (type == Double.TYPE) {
                            irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Double)leftConstantValue % (Double)rightConstantValue)));
                            break block85;
                        }
                        throw irBinaryMathNode.getLocation().createError(DefaultConstantFoldingOptimizationPhase.binaryError(PainlessLookupUtility.typeToCanonicalTypeName(type), operation.symbol, irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class), irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class)));
                    }
                    catch (ArithmeticException ae) {
                        throw irBinaryMathNode.getLocation().createError(ae);
                    }
                }
                scope.accept(irLeftConstantNode);
            } else if (operation == Operation.ADD) {
                if (type == Integer.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue + (Integer)rightConstantValue)));
                } else if (type == Long.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue + (Long)rightConstantValue)));
                } else if (type == Float.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant(Float.valueOf(((Float)leftConstantValue).floatValue() + ((Float)rightConstantValue).floatValue())));
                } else if (type == Double.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Double)leftConstantValue + (Double)rightConstantValue)));
                } else {
                    throw irBinaryMathNode.getLocation().createError(DefaultConstantFoldingOptimizationPhase.binaryError(PainlessLookupUtility.typeToCanonicalTypeName(type), operation.symbol, irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class), irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class)));
                }
                scope.accept(irLeftConstantNode);
            } else if (operation == Operation.SUB) {
                if (type == Integer.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue - (Integer)rightConstantValue)));
                } else if (type == Long.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue - (Long)rightConstantValue)));
                } else if (type == Float.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant(Float.valueOf(((Float)leftConstantValue).floatValue() - ((Float)rightConstantValue).floatValue())));
                } else if (type == Double.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Double)leftConstantValue - (Double)rightConstantValue)));
                } else {
                    throw irBinaryMathNode.getLocation().createError(DefaultConstantFoldingOptimizationPhase.binaryError(PainlessLookupUtility.typeToCanonicalTypeName(type), operation.symbol, irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class), irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class)));
                }
                scope.accept(irLeftConstantNode);
            } else if (operation == Operation.LSH) {
                if (type == Integer.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue << (Integer)rightConstantValue)));
                } else if (type == Long.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue << (Integer)rightConstantValue)));
                } else {
                    throw irBinaryMathNode.getLocation().createError(DefaultConstantFoldingOptimizationPhase.binaryError(PainlessLookupUtility.typeToCanonicalTypeName(type), operation.symbol, irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class), irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class)));
                }
                scope.accept(irLeftConstantNode);
            } else if (operation == Operation.RSH) {
                if (type == Integer.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue >> (Integer)rightConstantValue)));
                } else if (type == Long.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue >> (Integer)rightConstantValue)));
                } else {
                    throw irBinaryMathNode.getLocation().createError(DefaultConstantFoldingOptimizationPhase.binaryError(PainlessLookupUtility.typeToCanonicalTypeName(type), operation.symbol, irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class), irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class)));
                }
                scope.accept(irLeftConstantNode);
            } else if (operation == Operation.USH) {
                if (type == Integer.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue >>> (Integer)rightConstantValue)));
                } else if (type == Long.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue >>> (Integer)rightConstantValue)));
                } else {
                    throw irBinaryMathNode.getLocation().createError(DefaultConstantFoldingOptimizationPhase.binaryError(PainlessLookupUtility.typeToCanonicalTypeName(type), operation.symbol, irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class), irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class)));
                }
                scope.accept(irLeftConstantNode);
            } else if (operation == Operation.BWAND) {
                if (type == Integer.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue & (Integer)rightConstantValue)));
                } else if (type == Long.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue & (Long)rightConstantValue)));
                } else {
                    throw irBinaryMathNode.getLocation().createError(DefaultConstantFoldingOptimizationPhase.binaryError(PainlessLookupUtility.typeToCanonicalTypeName(type), operation.symbol, irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class), irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class)));
                }
                scope.accept(irLeftConstantNode);
            } else if (operation == Operation.XOR) {
                if (type == Boolean.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Boolean)leftConstantValue ^ (Boolean)rightConstantValue)));
                } else if (type == Integer.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue ^ (Integer)rightConstantValue)));
                } else if (type == Long.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue ^ (Long)rightConstantValue)));
                } else {
                    throw irBinaryMathNode.getLocation().createError(DefaultConstantFoldingOptimizationPhase.binaryError(PainlessLookupUtility.typeToCanonicalTypeName(type), operation.symbol, irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class), irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class)));
                }
                scope.accept(irLeftConstantNode);
            } else if (operation == Operation.BWOR) {
                if (type == Integer.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue | (Integer)rightConstantValue)));
                } else if (type == Long.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue | (Long)rightConstantValue)));
                } else {
                    throw irBinaryMathNode.getLocation().createError(DefaultConstantFoldingOptimizationPhase.binaryError(PainlessLookupUtility.typeToCanonicalTypeName(type), operation.symbol, irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class), irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class)));
                }
                scope.accept(irLeftConstantNode);
            }
        }
    }

    @Override
    public void visitStringConcatenation(StringConcatenationNode irStringConcatenationNode, Consumer<ExpressionNode> scope) {
        ExpressionNode irArgumentNode;
        irStringConcatenationNode.getArgumentNodes().get(0).visit(this, e -> irStringConcatenationNode.getArgumentNodes().set(0, (ExpressionNode)e));
        int i = 0;
        while (i < irStringConcatenationNode.getArgumentNodes().size() - 1) {
            ExpressionNode irLeftNode = irStringConcatenationNode.getArgumentNodes().get(i);
            ExpressionNode irRightNode = irStringConcatenationNode.getArgumentNodes().get(i + 1);
            int j = i;
            irRightNode.visit(this, e -> irStringConcatenationNode.getArgumentNodes().set(j + 1, (ExpressionNode)e));
            if (irLeftNode instanceof ConstantNode && irRightNode instanceof ConstantNode) {
                irLeftNode.attachDecoration(new IRDecorations.IRDConstant(String.valueOf(irLeftNode.getDecorationValue(IRDecorations.IRDConstant.class)) + String.valueOf(irRightNode.getDecorationValue(IRDecorations.IRDConstant.class))));
                irLeftNode.attachDecoration(new IRDecorations.IRDExpressionType(String.class));
                irStringConcatenationNode.getArgumentNodes().remove(i + 1);
                continue;
            }
            if (irLeftNode instanceof NullNode && irRightNode instanceof ConstantNode) {
                irRightNode.attachDecoration(new IRDecorations.IRDConstant("null" + String.valueOf(irRightNode.getDecorationValue(IRDecorations.IRDConstant.class))));
                irRightNode.attachDecoration(new IRDecorations.IRDExpressionType(String.class));
                irStringConcatenationNode.getArgumentNodes().remove(i);
                continue;
            }
            if (irLeftNode instanceof ConstantNode && irRightNode instanceof NullNode) {
                irLeftNode.attachDecoration(new IRDecorations.IRDConstant(String.valueOf(irLeftNode.getDecorationValue(IRDecorations.IRDConstant.class)) + "null"));
                irLeftNode.attachDecoration(new IRDecorations.IRDExpressionType(String.class));
                irStringConcatenationNode.getArgumentNodes().remove(i + 1);
                continue;
            }
            if (irLeftNode instanceof NullNode && irRightNode instanceof NullNode) {
                ConstantNode irConstantNode = new ConstantNode(irLeftNode.getLocation());
                irConstantNode.attachDecoration(new IRDecorations.IRDConstant(StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"nullnull"})));
                irConstantNode.attachDecoration(new IRDecorations.IRDExpressionType(String.class));
                irStringConcatenationNode.getArgumentNodes().set(i, irConstantNode);
                irStringConcatenationNode.getArgumentNodes().remove(i + 1);
                continue;
            }
            ++i;
        }
        if (irStringConcatenationNode.getArgumentNodes().size() == 1 && (irArgumentNode = irStringConcatenationNode.getArgumentNodes().get(0)) instanceof ConstantNode) {
            scope.accept(irArgumentNode);
        }
    }

    @Override
    public void visitBoolean(BooleanNode irBooleanNode, Consumer<ExpressionNode> scope) {
        irBooleanNode.getLeftNode().visit(this, irBooleanNode::setLeftNode);
        irBooleanNode.getRightNode().visit(this, irBooleanNode::setRightNode);
        if (irBooleanNode.getLeftNode() instanceof ConstantNode && irBooleanNode.getRightNode() instanceof ConstantNode) {
            ExpressionNode irLeftConstantNode = irBooleanNode.getLeftNode();
            ExpressionNode irRightConstantNode = irBooleanNode.getRightNode();
            Operation operation = (Operation)((Object)irBooleanNode.getDecorationValue(IRDecorations.IRDOperation.class));
            Class type = (Class)irBooleanNode.getDecorationValue(IRDecorations.IRDExpressionType.class);
            if (operation == Operation.AND) {
                if (type != Boolean.TYPE) {
                    throw irBooleanNode.getLocation().createError(DefaultConstantFoldingOptimizationPhase.binaryError(PainlessLookupUtility.typeToCanonicalTypeName(type), operation.symbol, irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class), irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class)));
                }
                irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Boolean)irLeftConstantNode.getDecorationValue(IRDecorations.IRDConstant.class) != false && (Boolean)irRightConstantNode.getDecorationValue(IRDecorations.IRDConstant.class) != false ? 1 : 0)));
                scope.accept(irLeftConstantNode);
            } else if (operation == Operation.OR) {
                if (type != Boolean.TYPE) {
                    throw irBooleanNode.getLocation().createError(DefaultConstantFoldingOptimizationPhase.booleanError(PainlessLookupUtility.typeToCanonicalTypeName(type), operation.symbol, irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class), irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class)));
                }
                irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Boolean)irLeftConstantNode.getDecorationValue(IRDecorations.IRDConstant.class) != false || (Boolean)irRightConstantNode.getDecorationValue(IRDecorations.IRDConstant.class) != false ? 1 : 0)));
                scope.accept(irLeftConstantNode);
            }
        }
    }

    @Override
    public void visitComparison(ComparisonNode irComparisonNode, Consumer<ExpressionNode> scope) {
        irComparisonNode.getLeftNode().visit(this, irComparisonNode::setLeftNode);
        irComparisonNode.getRightNode().visit(this, irComparisonNode::setRightNode);
        if ((irComparisonNode.getLeftNode() instanceof ConstantNode || irComparisonNode.getLeftNode() instanceof NullNode) && (irComparisonNode.getRightNode() instanceof ConstantNode || irComparisonNode.getRightNode() instanceof NullNode)) {
            ExpressionNode irLeftConstantNode = irComparisonNode.getLeftNode() instanceof NullNode ? null : irComparisonNode.getLeftNode();
            ExpressionNode irRightConstantNode = irComparisonNode.getRightNode() instanceof NullNode ? null : irComparisonNode.getRightNode();
            Object leftConstantValue = irLeftConstantNode == null ? null : (Object)irLeftConstantNode.getDecorationValue(IRDecorations.IRDConstant.class);
            Object rightConstantValue = irRightConstantNode == null ? null : irRightConstantNode.getDecorationValue(IRDecorations.IRDConstant.class);
            Operation operation = (Operation)((Object)irComparisonNode.getDecorationValue(IRDecorations.IRDOperation.class));
            Class type = (Class)irComparisonNode.getDecorationValue(IRDecorations.IRDComparisonType.class);
            if (operation == Operation.EQ || operation == Operation.EQR) {
                if (irLeftConstantNode == null && irRightConstantNode == null) {
                    irLeftConstantNode = new ConstantNode(irComparisonNode.getLeftNode().getLocation());
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)true));
                } else if (irLeftConstantNode == null || irRightConstantNode == null) {
                    irLeftConstantNode = new ConstantNode(irComparisonNode.getLeftNode().getLocation());
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)false));
                } else if (type == Boolean.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(((Boolean)leftConstantValue).booleanValue() == ((Boolean)rightConstantValue).booleanValue() ? 1 : 0)));
                } else if (type == Integer.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(((Integer)leftConstantValue).intValue() == ((Integer)rightConstantValue).intValue() ? 1 : 0)));
                } else if (type == Long.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(((Long)leftConstantValue).longValue() == ((Long)rightConstantValue).longValue() ? 1 : 0)));
                } else if (type == Float.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(((Float)leftConstantValue).floatValue() == ((Float)rightConstantValue).floatValue() ? 1 : 0)));
                } else if (type == Double.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(((Double)leftConstantValue).doubleValue() == ((Double)rightConstantValue).doubleValue() ? 1 : 0)));
                } else if (operation == Operation.EQ) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)leftConstantValue.equals(rightConstantValue)));
                } else {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(leftConstantValue == rightConstantValue ? 1 : 0)));
                }
                irLeftConstantNode.attachDecoration(new IRDecorations.IRDExpressionType(Boolean.TYPE));
                scope.accept(irLeftConstantNode);
            } else if (operation == Operation.NE || operation == Operation.NER) {
                if (irLeftConstantNode == null && irRightConstantNode == null) {
                    irLeftConstantNode = new ConstantNode(irComparisonNode.getLeftNode().getLocation());
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)false));
                } else if (irLeftConstantNode == null || irRightConstantNode == null) {
                    irLeftConstantNode = new ConstantNode(irComparisonNode.getLeftNode().getLocation());
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)true));
                } else if (type == Boolean.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(((Boolean)leftConstantValue).booleanValue() != ((Boolean)rightConstantValue).booleanValue() ? 1 : 0)));
                } else if (type == Integer.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(((Integer)leftConstantValue).intValue() != ((Integer)rightConstantValue).intValue() ? 1 : 0)));
                } else if (type == Long.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(((Long)leftConstantValue).longValue() != ((Long)rightConstantValue).longValue() ? 1 : 0)));
                } else if (type == Float.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(((Float)leftConstantValue).floatValue() != ((Float)rightConstantValue).floatValue() ? 1 : 0)));
                } else if (type == Double.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(((Double)leftConstantValue).doubleValue() != ((Double)rightConstantValue).doubleValue() ? 1 : 0)));
                } else if (operation == Operation.NE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(!leftConstantValue.equals(rightConstantValue) ? 1 : 0)));
                } else {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(leftConstantValue != rightConstantValue ? 1 : 0)));
                }
                irLeftConstantNode.attachDecoration(new IRDecorations.IRDExpressionType(Boolean.TYPE));
                scope.accept(irLeftConstantNode);
            } else if (irLeftConstantNode != null && irRightConstantNode != null) {
                if (operation == Operation.GT) {
                    if (type == Integer.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue > (Integer)rightConstantValue ? 1 : 0)));
                    } else if (type == Long.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue > (Long)rightConstantValue ? 1 : 0)));
                    } else if (type == Float.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(((Float)leftConstantValue).floatValue() > ((Float)rightConstantValue).floatValue() ? 1 : 0)));
                    } else if (type == Double.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Double)leftConstantValue > (Double)rightConstantValue ? 1 : 0)));
                    } else {
                        throw irComparisonNode.getLocation().createError(DefaultConstantFoldingOptimizationPhase.comparisonError(PainlessLookupUtility.typeToCanonicalTypeName(type), operation.symbol, irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class), irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class)));
                    }
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDExpressionType(Boolean.TYPE));
                    scope.accept(irLeftConstantNode);
                } else if (operation == Operation.GTE) {
                    if (type == Integer.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue >= (Integer)rightConstantValue ? 1 : 0)));
                    } else if (type == Long.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue >= (Long)rightConstantValue ? 1 : 0)));
                    } else if (type == Float.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(((Float)leftConstantValue).floatValue() >= ((Float)rightConstantValue).floatValue() ? 1 : 0)));
                    } else if (type == Double.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Double)leftConstantValue >= (Double)rightConstantValue ? 1 : 0)));
                    } else {
                        throw irComparisonNode.getLocation().createError(DefaultConstantFoldingOptimizationPhase.comparisonError(PainlessLookupUtility.typeToCanonicalTypeName(type), operation.symbol, irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class), irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class)));
                    }
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDExpressionType(Boolean.TYPE));
                    scope.accept(irLeftConstantNode);
                } else if (operation == Operation.LT) {
                    if (type == Integer.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue < (Integer)rightConstantValue ? 1 : 0)));
                    } else if (type == Long.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue < (Long)rightConstantValue ? 1 : 0)));
                    } else if (type == Float.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(((Float)leftConstantValue).floatValue() < ((Float)rightConstantValue).floatValue() ? 1 : 0)));
                    } else if (type == Double.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Double)leftConstantValue < (Double)rightConstantValue ? 1 : 0)));
                    } else {
                        throw irComparisonNode.getLocation().createError(DefaultConstantFoldingOptimizationPhase.comparisonError(PainlessLookupUtility.typeToCanonicalTypeName(type), operation.symbol, irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class), irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class)));
                    }
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDExpressionType(Boolean.TYPE));
                    scope.accept(irLeftConstantNode);
                } else if (operation == Operation.LTE) {
                    if (type == Integer.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue <= (Integer)rightConstantValue ? 1 : 0)));
                    } else if (type == Long.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue <= (Long)rightConstantValue ? 1 : 0)));
                    } else if (type == Float.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(((Float)leftConstantValue).floatValue() <= ((Float)rightConstantValue).floatValue() ? 1 : 0)));
                    } else if (type == Double.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Double)leftConstantValue <= (Double)rightConstantValue ? 1 : 0)));
                    } else {
                        throw irComparisonNode.getLocation().createError(DefaultConstantFoldingOptimizationPhase.comparisonError(PainlessLookupUtility.typeToCanonicalTypeName(type), operation.symbol, irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class), irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class)));
                    }
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDExpressionType(Boolean.TYPE));
                    scope.accept(irLeftConstantNode);
                }
            }
        }
    }

    @Override
    public void visitCast(CastNode irCastNode, Consumer<ExpressionNode> scope) {
        irCastNode.getChildNode().visit(this, irCastNode::setChildNode);
        if (irCastNode.getChildNode() instanceof ConstantNode && PainlessLookupUtility.isConstantType((Class)irCastNode.getDecorationValue(IRDecorations.IRDExpressionType.class))) {
            ExpressionNode irConstantNode = irCastNode.getChildNode();
            Object constantValue = irConstantNode.getDecorationValue(IRDecorations.IRDConstant.class);
            constantValue = AnalyzerCaster.constCast(irCastNode.getLocation(), constantValue, (PainlessCast)irCastNode.getDecorationValue(IRDecorations.IRDCast.class));
            irConstantNode.attachDecoration(new IRDecorations.IRDConstant(constantValue));
            irConstantNode.attachDecoration(irCastNode.getDecoration(IRDecorations.IRDExpressionType.class));
            scope.accept(irConstantNode);
        }
    }

    @Override
    public void visitInvokeCallMember(InvokeCallMemberNode irInvokeCallMemberNode, Consumer<ExpressionNode> scope) {
        for (int i = 0; i < irInvokeCallMemberNode.getArgumentNodes().size(); ++i) {
            int j = i;
            irInvokeCallMemberNode.getArgumentNodes().get(i).visit(this, e -> irInvokeCallMemberNode.getArgumentNodes().set(j, (ExpressionNode)e));
        }
        PainlessMethod method = (PainlessMethod)irInvokeCallMemberNode.getDecorationValue(IRDecorations.IRDMethod.class);
        if (method != null && method.annotations().containsKey(CompileTimeOnlyAnnotation.class)) {
            DefaultConstantFoldingOptimizationPhase.replaceCallWithConstant(irInvokeCallMemberNode, scope, method.javaMethod(), null);
            return;
        }
        PainlessInstanceBinding instanceBinding = (PainlessInstanceBinding)irInvokeCallMemberNode.getDecorationValue(IRDecorations.IRDInstanceBinding.class);
        if (instanceBinding != null && instanceBinding.annotations().containsKey(CompileTimeOnlyAnnotation.class)) {
            DefaultConstantFoldingOptimizationPhase.replaceCallWithConstant(irInvokeCallMemberNode, scope, instanceBinding.javaMethod(), instanceBinding.targetInstance());
            return;
        }
    }

    private static void replaceCallWithConstant(InvokeCallMemberNode irInvokeCallMemberNode, Consumer<ExpressionNode> scope, Method javaMethod, Object receiver) {
        Object result;
        Object[] args = new Object[irInvokeCallMemberNode.getArgumentNodes().size()];
        for (int i = 0; i < irInvokeCallMemberNode.getArgumentNodes().size(); ++i) {
            ExpressionNode argNode = irInvokeCallMemberNode.getArgumentNodes().get(i);
            IRDecorations.IRDConstant constantDecoration = argNode.getDecoration(IRDecorations.IRDConstant.class);
            if (constantDecoration == null) {
                throw irInvokeCallMemberNode.getLocation().createError(new IllegalArgumentException("all arguments to [" + javaMethod.getName() + "] must be constant but the [" + (i + 1) + "] argument isn't"));
            }
            args[i] = constantDecoration.getValue();
        }
        try {
            result = javaMethod.invoke(receiver, args);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw irInvokeCallMemberNode.getLocation().createError(new IllegalArgumentException("error invoking [" + String.valueOf(irInvokeCallMemberNode) + "] at compile time", e));
        }
        catch (InvocationTargetException e) {
            throw irInvokeCallMemberNode.getLocation().createError(new IllegalArgumentException("error invoking [" + String.valueOf(irInvokeCallMemberNode) + "] at compile time", e.getCause()));
        }
        ConstantNode replacement = new ConstantNode(irInvokeCallMemberNode.getLocation());
        replacement.attachDecoration(new IRDecorations.IRDConstant(result));
        replacement.attachDecoration(irInvokeCallMemberNode.getDecoration(IRDecorations.IRDExpressionType.class));
        scope.accept(replacement);
    }
}

