/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.syncjob.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.connector.action.ConnectorUpdateActionResponse;
import org.elasticsearch.xpack.application.connector.syncjob.ConnectorSyncJob;
import org.elasticsearch.xpack.application.connector.syncjob.action.ConnectorSyncJobActionRequest;

public class UpdateConnectorSyncJobErrorAction {
    public static final String NAME = "indices:data/write/xpack/connector/sync_job/update_error";
    public static final ActionType<ConnectorUpdateActionResponse> INSTANCE = new ActionType("indices:data/write/xpack/connector/sync_job/update_error");
    public static final String ERROR_EMPTY_MESSAGE = "[error] of the connector sync job cannot be null or empty";

    private UpdateConnectorSyncJobErrorAction() {
    }

    public static class Request
    extends ConnectorSyncJobActionRequest
    implements ToXContentObject {
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("connector_sync_job_error_request", false, (args, connectorSyncJobId) -> new Request((String)connectorSyncJobId, (String)args[0]));
        private final String connectorSyncJobId;
        private final String error;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.connectorSyncJobId = in.readString();
            this.error = in.readString();
        }

        public Request(String connectorSyncJobId, String error) {
            this.connectorSyncJobId = connectorSyncJobId;
            this.error = error;
        }

        public static Request fromXContent(XContentParser parser, String connectorSyncJobId) throws IOException {
            return (Request)((Object)PARSER.parse(parser, (Object)connectorSyncJobId));
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.connectorSyncJobId)) {
                validationException = ValidateActions.addValidationError((String)"[connector_sync_job_id] of the connector sync job cannot be null or empty.", validationException);
            }
            if (Strings.isNullOrEmpty((String)this.error)) {
                validationException = ValidateActions.addValidationError((String)UpdateConnectorSyncJobErrorAction.ERROR_EMPTY_MESSAGE, (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public String getConnectorSyncJobId() {
            return this.connectorSyncJobId;
        }

        public String getError() {
            return this.error;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.connectorSyncJobId);
            out.writeString(this.error);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.connectorSyncJobId, request.connectorSyncJobId) && Objects.equals(this.error, request.error);
        }

        public int hashCode() {
            return Objects.hash(this.connectorSyncJobId, this.error);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(ConnectorSyncJob.ERROR_FIELD.getPreferredName(), this.error);
            builder.endObject();
            return builder;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), ConnectorSyncJob.ERROR_FIELD);
        }
    }
}

