/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class ConnectorsAPISearchResult
implements Writeable,
ToXContentObject {
    private final BytesReference resultBytes;
    private final Map<String, Object> resultMap;
    private final String docId;

    protected ConnectorsAPISearchResult(BytesReference resultBytes, Map<String, Object> resultMap, String id) {
        this.resultBytes = resultBytes;
        this.resultMap = resultMap;
        this.docId = id;
    }

    public ConnectorsAPISearchResult(StreamInput in) throws IOException {
        this.resultBytes = in.readBytesReference();
        this.resultMap = in.readGenericMap();
        this.docId = in.readString();
    }

    public BytesReference getSourceRef() {
        return this.resultBytes;
    }

    public Map<String, Object> getResultMap() {
        return this.resultMap;
    }

    public String getDocId() {
        return this.docId;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("id", this.docId);
        builder.mapContents(this.resultMap);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBytesReference(this.resultBytes);
        out.writeGenericMap(this.resultMap);
        out.writeString(this.docId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectorsAPISearchResult that = (ConnectorsAPISearchResult)o;
        return Objects.equals(this.resultBytes, that.resultBytes) && Objects.equals(this.resultMap, that.resultMap) && Objects.equals(this.docId, that.docId);
    }

    public int hashCode() {
        return Objects.hash(this.resultBytes, this.resultMap, this.docId);
    }
}

