/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamOutput;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

record RemoteClusterPlan(PhysicalPlan plan, String[] targetIndices, OriginalIndices originalIndices) {
    static RemoteClusterPlan from(PlanStreamInput planIn) throws IOException {
        PhysicalPlan plan = (PhysicalPlan)planIn.readNamedWriteable(PhysicalPlan.class);
        String[] targetIndices = planIn.readStringArray();
        OriginalIndices originalIndices = planIn.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_ORIGINAL_INDICES) ? OriginalIndices.readOriginalIndices((StreamInput)planIn) : new OriginalIndices(planIn.readStringArray(), SearchRequest.DEFAULT_INDICES_OPTIONS);
        return new RemoteClusterPlan(plan, targetIndices, originalIndices);
    }

    public void writeTo(PlanStreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.plan);
        out.writeStringArray(this.targetIndices);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_ORIGINAL_INDICES)) {
            OriginalIndices.writeOriginalIndices((OriginalIndices)this.originalIndices, (StreamOutput)out);
        } else {
            out.writeStringArray(this.originalIndices.indices());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteClusterPlan that = (RemoteClusterPlan)o;
        return Objects.equals((Object)this.plan, (Object)that.plan) && Objects.deepEquals(this.targetIndices, that.targetIndices) && Objects.equals(this.originalIndices, that.originalIndices);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.plan, Arrays.hashCode(this.targetIndices), this.originalIndices});
    }
}

