/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.Build;
import org.elasticsearch.Version;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.features.FeatureSpecification;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.xpack.esql.plugin.TransportEsqlStatsAction;

public class EsqlFeatures
implements FeatureSpecification {
    private static final NodeFeature MV_SORT = new NodeFeature("esql.mv_sort");
    private static final NodeFeature DISABLE_NULLABLE_OPTS = new NodeFeature("esql.disable_nullable_opts");
    private static final NodeFeature ST_X_Y = new NodeFeature("esql.st_x_y");
    private static final NodeFeature MV_WARN = new NodeFeature("esql.mv_warn");
    private static final NodeFeature SPATIAL_POINTS = new NodeFeature("esql.spatial_points");
    private static final NodeFeature SPATIAL_POINTS_FROM_SOURCE = new NodeFeature("esql.spatial_points_from_source");
    private static final NodeFeature CONVERT_WARN = new NodeFeature("esql.convert_warn");
    private static final NodeFeature POW_DOUBLE = new NodeFeature("esql.pow_double");
    private static final NodeFeature SPATIAL_SHAPES = new NodeFeature("esql.spatial_shapes");
    private static final NodeFeature ST_CENTROID_AGG = new NodeFeature("esql.st_centroid_agg");
    private static final NodeFeature ST_INTERSECTS = new NodeFeature("esql.st_intersects");
    private static final NodeFeature ST_CONTAINS_WITHIN = new NodeFeature("esql.st_contains_within");
    private static final NodeFeature ST_DISJOINT = new NodeFeature("esql.st_disjoint");
    private static final NodeFeature AGG_VALUES = new NodeFeature("esql.agg_values");
    public static final NodeFeature ASYNC_QUERY = new NodeFeature("esql.async_query");
    @Deprecated
    public static final NodeFeature FROM_OPTIONS = new NodeFeature("esql.from_options");
    public static final NodeFeature STRING_LITERAL_AUTO_CASTING = new NodeFeature("esql.string_literal_auto_casting");
    public static final NodeFeature BASE64_DECODE_ENCODE = new NodeFeature("esql.base64_decode_encode");
    public static final NodeFeature CASTING_OPERATOR = new NodeFeature("esql.casting_operator");
    public static final NodeFeature MV_ORDERING_SORTED_ASCENDING = new NodeFeature("esql.mv_ordering_sorted_ascending");
    public static final NodeFeature METRICS_COUNTER_FIELDS = new NodeFeature("esql.metrics_counter_fields");
    public static final NodeFeature STRING_LITERAL_AUTO_CASTING_EXTENDED = new NodeFeature("esql.string_literal_auto_casting_extended");
    public static final NodeFeature METADATA_FIELDS = new NodeFeature("esql.metadata_fields");
    public static final NodeFeature ENRICH_LOAD = new NodeFeature("esql.enrich_load");
    public static final NodeFeature TIMESPAN_ABBREVIATIONS = new NodeFeature("esql.timespan_abbreviations");
    public static final NodeFeature COUNTER_TYPES = new NodeFeature("esql.counter_types");
    public static final NodeFeature METRICS_SYNTAX = new NodeFeature("esql.metrics_syntax");
    public static final NodeFeature RESOLVE_FIELDS_API = new NodeFeature("esql.resolve_fields_api");

    private Set<NodeFeature> snapshotBuildFeatures() {
        assert (Build.current().isSnapshot()) : Build.current();
        return Set.of(METRICS_SYNTAX);
    }

    public Set<NodeFeature> getFeatures() {
        Set<NodeFeature> features = Set.of(ASYNC_QUERY, AGG_VALUES, BASE64_DECODE_ENCODE, MV_SORT, DISABLE_NULLABLE_OPTS, ST_X_Y, FROM_OPTIONS, SPATIAL_POINTS_FROM_SOURCE, SPATIAL_SHAPES, ST_CENTROID_AGG, ST_INTERSECTS, ST_CONTAINS_WITHIN, ST_DISJOINT, STRING_LITERAL_AUTO_CASTING, CASTING_OPERATOR, MV_ORDERING_SORTED_ASCENDING, METRICS_COUNTER_FIELDS, STRING_LITERAL_AUTO_CASTING_EXTENDED, METADATA_FIELDS, TIMESPAN_ABBREVIATIONS, COUNTER_TYPES, RESOLVE_FIELDS_API);
        if (Build.current().isSnapshot()) {
            return Collections.unmodifiableSet(Sets.union(features, this.snapshotBuildFeatures()));
        }
        return features;
    }

    public Map<NodeFeature, Version> getHistoricalFeatures() {
        return Map.ofEntries(Map.entry(TransportEsqlStatsAction.ESQL_STATS_FEATURE, Version.V_8_11_0), Map.entry(MV_WARN, Version.V_8_12_0), Map.entry(SPATIAL_POINTS, Version.V_8_12_0), Map.entry(CONVERT_WARN, Version.V_8_12_0), Map.entry(POW_DOUBLE, Version.V_8_12_0), Map.entry(ENRICH_LOAD, Version.V_8_12_0));
    }
}

