/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.capabilities.Resolvables;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;

public class Aggregate
extends UnaryPlan {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "Aggregate", Aggregate::new);
    private final AggregateType aggregateType;
    private final List<Expression> groupings;
    private final List<? extends NamedExpression> aggregates;
    private List<Attribute> lazyOutput;

    public Aggregate(Source source, LogicalPlan child, AggregateType aggregateType, List<Expression> groupings, List<? extends NamedExpression> aggregates) {
        super(source, child);
        this.aggregateType = aggregateType;
        this.groupings = groupings;
        this.aggregates = aggregates;
    }

    public Aggregate(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (LogicalPlan)in.readNamedWriteable(LogicalPlan.class), AggregateType.readType(in), in.readNamedWriteableCollectionAsList(Expression.class), in.readNamedWriteableCollectionAsList(NamedExpression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.child());
        AggregateType.writeType(out, this.aggregateType());
        out.writeNamedWriteableCollection(this.groupings);
        out.writeNamedWriteableCollection(this.aggregates());
    }

    public String getWriteableName() {
        return Aggregate.ENTRY.name;
    }

    protected NodeInfo<Aggregate> info() {
        return NodeInfo.create((Node)this, Aggregate::new, (Object)((Object)this.child()), (Object)((Object)this.aggregateType), this.groupings, this.aggregates);
    }

    @Override
    public Aggregate replaceChild(LogicalPlan newChild) {
        return new Aggregate(this.source(), newChild, this.aggregateType, this.groupings, this.aggregates);
    }

    public Aggregate with(List<Expression> newGroupings, List<? extends NamedExpression> newAggregates) {
        return this.with(this.child(), newGroupings, newAggregates);
    }

    public Aggregate with(LogicalPlan child, List<Expression> newGroupings, List<? extends NamedExpression> newAggregates) {
        return new Aggregate(this.source(), child, this.aggregateType(), newGroupings, newAggregates);
    }

    public AggregateType aggregateType() {
        return this.aggregateType;
    }

    public List<Expression> groupings() {
        return this.groupings;
    }

    public List<? extends NamedExpression> aggregates() {
        return this.aggregates;
    }

    @Override
    public String commandName() {
        return switch (this.aggregateType) {
            default -> throw new IncompatibleClassChangeError();
            case AggregateType.STANDARD -> "STATS";
            case AggregateType.METRICS -> "METRICS";
        };
    }

    @Override
    public boolean expressionsResolved() {
        return Resolvables.resolved(this.groupings) && Resolvables.resolved(this.aggregates);
    }

    @Override
    public List<Attribute> output() {
        if (this.lazyOutput == null) {
            this.lazyOutput = Aggregate.output(this.aggregates);
        }
        return this.lazyOutput;
    }

    public static List<Attribute> output(List<? extends NamedExpression> aggregates) {
        return NamedExpressions.mergeOutputAttributes(Expressions.asAttributes(aggregates), Collections.emptyList());
    }

    @Override
    protected AttributeSet computeReferences() {
        return Aggregate.computeReferences(this.aggregates, this.groupings);
    }

    public static AttributeSet computeReferences(List<? extends NamedExpression> aggregates, List<? extends Expression> groupings) {
        AttributeSet result = Expressions.references(groupings).combine(Expressions.references(aggregates));
        for (Expression expression : groupings) {
            if (!(expression instanceof Alias)) continue;
            result.remove((Object)((Alias)expression).toAttribute());
        }
        return result;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.aggregateType, this.groupings, this.aggregates, this.child()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Aggregate other = (Aggregate)((Object)obj);
        return this.aggregateType == other.aggregateType && Objects.equals(this.groupings, other.groupings) && Objects.equals(this.aggregates, other.aggregates) && Objects.equals((Object)this.child(), (Object)other.child());
    }

    public static enum AggregateType {
        STANDARD,
        METRICS;


        static void writeType(StreamOutput out, AggregateType type) throws IOException {
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_15_0)) {
                out.writeString(type.name());
            } else if (type != STANDARD) {
                throw new IllegalStateException("cluster is not ready to support aggregate type [" + String.valueOf((Object)type) + "]");
            }
        }

        static AggregateType readType(StreamInput in) throws IOException {
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_15_0)) {
                return AggregateType.valueOf(in.readString());
            }
            return STANDARD;
        }
    }
}

