/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlConfigurationFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.ToUpperEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.session.Configuration;

public class ToUpper
extends EsqlConfigurationFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ToUpper", ToUpper::new);
    private final Expression field;

    @FunctionInfo(returnType={"keyword"}, description="Returns a new string representing the input string converted to upper case.", examples={@Example(file="string", tag="to_upper")})
    public ToUpper(Source source, @Param(name="str", type={"keyword", "text"}, description="String expression. If `null`, the function returns `null`.") Expression field, Configuration configuration) {
        super(source, List.of(field), configuration);
        this.field = field;
    }

    private ToUpper(StreamInput in) throws IOException {
        this(Source.EMPTY, (Expression)in.readNamedWriteable(Expression.class), ((PlanStreamInput)in).configuration());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.field);
    }

    public String getWriteableName() {
        return ToUpper.ENTRY.name;
    }

    public DataType dataType() {
        return DataType.KEYWORD;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isString((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT);
    }

    public boolean foldable() {
        return this.field.foldable();
    }

    static BytesRef process(BytesRef val, Locale locale) {
        return BytesRefs.toBytesRef((Object)val.utf8ToString().toUpperCase(locale));
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory fieldEvaluator = toEvaluator.apply(this.field);
        return new ToUpperEvaluator.Factory(this.source(), fieldEvaluator, this.configuration().locale());
    }

    public Expression field() {
        return this.field;
    }

    public ToUpper replaceChild(Expression child) {
        return new ToUpper(this.source(), child, this.configuration());
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        assert (newChildren.size() == 1);
        return this.replaceChild(newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToUpper::new, (Object)this.field, (Object)this.configuration());
    }
}

