/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.geo.Component2D;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.index.mapper.GeoShapeIndexer;
import org.elasticsearch.index.mapper.ShapeIndexer;
import org.elasticsearch.lucene.spatial.CartesianShapeIndexer;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;
import org.elasticsearch.lucene.spatial.GeometryDocValueReader;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.BinarySpatialFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialEvaluatorFactory;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialIntersectsCartesianPointDocValuesAndConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialIntersectsCartesianPointDocValuesAndSourceEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialIntersectsCartesianSourceAndConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialIntersectsCartesianSourceAndSourceEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialIntersectsGeoPointDocValuesAndConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialIntersectsGeoPointDocValuesAndSourceEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialIntersectsGeoSourceAndConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialIntersectsGeoSourceAndSourceEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesUtils;

public class SpatialIntersects
extends SpatialRelatesFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "SpatialIntersects", SpatialIntersects::new);
    public static final SpatialRelatesFunction.SpatialRelations GEO = new SpatialRelatesFunction.SpatialRelations(ShapeField.QueryRelation.INTERSECTS, SpatialCoordinateTypes.GEO, CoordinateEncoder.GEO, (ShapeIndexer)new GeoShapeIndexer(Orientation.CCW, "ST_Intersects"));
    public static final SpatialRelatesFunction.SpatialRelations CARTESIAN = new SpatialRelatesFunction.SpatialRelations(ShapeField.QueryRelation.INTERSECTS, SpatialCoordinateTypes.CARTESIAN, CoordinateEncoder.CARTESIAN, (ShapeIndexer)new CartesianShapeIndexer("ST_Intersects"));
    private static final Map<SpatialEvaluatorFactory.SpatialEvaluatorKey, SpatialEvaluatorFactory<?, ?>> evaluatorMap = new HashMap();

    @FunctionInfo(returnType={"boolean"}, description="Returns true if two geometries intersect.\nThey intersect if they have any point in common, including their interior points\n(points along lines or within polygons).\nThis is the inverse of the <<esql-st_disjoint,ST_DISJOINT>> function.\nIn mathematical terms: ST_Intersects(A, B) \u21d4 A \u22c2 B \u2260 \u2205", examples={@Example(file="spatial", tag="st_intersects-airports")})
    public SpatialIntersects(Source source, @Param(name="geomA", type={"geo_point", "cartesian_point", "geo_shape", "cartesian_shape"}, description="Expression of type `geo_point`, `cartesian_point`, `geo_shape` or `cartesian_shape`.\nIf `null`, the function returns `null`.") Expression left, @Param(name="geomB", type={"geo_point", "cartesian_point", "geo_shape", "cartesian_shape"}, description="Expression of type `geo_point`, `cartesian_point`, `geo_shape` or `cartesian_shape`.\nIf `null`, the function returns `null`.\nThe second parameter must also have the same coordinate system as the first.\nThis means it is not possible to combine `geo_*` and `cartesian_*` parameters.") Expression right) {
        this(source, left, right, false, false);
    }

    private SpatialIntersects(Source source, Expression left, Expression right, boolean leftDocValues, boolean rightDocValues) {
        super(source, left, right, leftDocValues, rightDocValues);
    }

    private SpatialIntersects(StreamInput in) throws IOException {
        super(in, false, false);
    }

    public String getWriteableName() {
        return SpatialIntersects.ENTRY.name;
    }

    @Override
    public ShapeRelation queryRelation() {
        return ShapeRelation.INTERSECTS;
    }

    @Override
    public SpatialIntersects withDocValues(boolean foundLeft, boolean foundRight) {
        boolean leftDV = this.leftDocValues || foundLeft;
        boolean rightDV = this.rightDocValues || foundRight;
        return new SpatialIntersects(this.source(), this.left(), this.right(), leftDV, rightDV);
    }

    protected SpatialIntersects replaceChildren(Expression newLeft, Expression newRight) {
        return new SpatialIntersects(this.source(), newLeft, newRight, this.leftDocValues, this.rightDocValues);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, SpatialIntersects::new, (Object)this.left(), (Object)this.right());
    }

    @Override
    public Object fold() {
        try {
            GeometryDocValueReader docValueReader = SpatialRelatesUtils.asGeometryDocValueReader(this.crsType(), this.left());
            Component2D component2D = SpatialRelatesUtils.asLuceneComponent2D(this.crsType(), this.right());
            return this.crsType() == BinarySpatialFunction.SpatialCrsType.GEO ? GEO.geometryRelatesGeometry(docValueReader, component2D) : CARTESIAN.geometryRelatesGeometry(docValueReader, component2D);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to fold constant fields: " + e.getMessage(), e);
        }
    }

    @Override
    Map<SpatialEvaluatorFactory.SpatialEvaluatorKey, SpatialEvaluatorFactory<?, ?>> evaluatorRules() {
        return evaluatorMap;
    }

    static void processGeoSourceAndConstant(BooleanBlock.Builder results, int p, BytesRefBlock left, Component2D right) throws IOException {
        GEO.processSourceAndConstant(results, p, left, right);
    }

    static void processGeoSourceAndSource(BooleanBlock.Builder builder, int p, BytesRefBlock left, BytesRefBlock right) throws IOException {
        GEO.processSourceAndSource(builder, p, left, right);
    }

    static void processGeoPointDocValuesAndConstant(BooleanBlock.Builder builder, int p, LongBlock left, Component2D right) throws IOException {
        GEO.processPointDocValuesAndConstant(builder, p, left, right);
    }

    static void processGeoPointDocValuesAndSource(BooleanBlock.Builder builder, int p, LongBlock left, BytesRefBlock right) throws IOException {
        GEO.processPointDocValuesAndSource(builder, p, left, right);
    }

    static void processCartesianSourceAndConstant(BooleanBlock.Builder builder, int p, BytesRefBlock left, Component2D right) throws IOException {
        CARTESIAN.processSourceAndConstant(builder, p, left, right);
    }

    static void processCartesianSourceAndSource(BooleanBlock.Builder builder, int p, BytesRefBlock left, BytesRefBlock right) throws IOException {
        CARTESIAN.processSourceAndSource(builder, p, left, right);
    }

    static void processCartesianPointDocValuesAndConstant(BooleanBlock.Builder builder, int p, LongBlock left, Component2D right) throws IOException {
        CARTESIAN.processPointDocValuesAndConstant(builder, p, left, right);
    }

    static void processCartesianPointDocValuesAndSource(BooleanBlock.Builder builder, int p, LongBlock left, BytesRefBlock right) throws IOException {
        CARTESIAN.processPointDocValuesAndSource(builder, p, left, right);
    }

    static {
        for (DataType spatialType : new DataType[]{DataType.GEO_POINT, DataType.GEO_SHAPE}) {
            for (DataType otherType : new DataType[]{DataType.GEO_POINT, DataType.GEO_SHAPE}) {
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSources(spatialType, otherType), new SpatialEvaluatorFactory.SpatialEvaluatorFactoryWithFields((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialIntersectsGeoSourceAndSourceEvaluator.Factory::new)));
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSourceAndConstant(spatialType, otherType), new SpatialEvaluatorFactory.SpatialEvaluatorWithConstantFactory((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, Component2D, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialIntersectsGeoSourceAndConstantEvaluator.Factory::new)));
                if (!DataType.isSpatialPoint((DataType)spatialType)) continue;
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSources(spatialType, otherType).withLeftDocValues(), new SpatialEvaluatorFactory.SpatialEvaluatorFactoryWithFields((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialIntersectsGeoPointDocValuesAndSourceEvaluator.Factory::new)));
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSourceAndConstant(spatialType, otherType).withLeftDocValues(), new SpatialEvaluatorFactory.SpatialEvaluatorWithConstantFactory((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, Component2D, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialIntersectsGeoPointDocValuesAndConstantEvaluator.Factory::new)));
            }
        }
        for (DataType spatialType : new DataType[]{DataType.CARTESIAN_POINT, DataType.CARTESIAN_SHAPE}) {
            for (DataType otherType : new DataType[]{DataType.CARTESIAN_POINT, DataType.CARTESIAN_SHAPE}) {
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSources(spatialType, otherType), new SpatialEvaluatorFactory.SpatialEvaluatorFactoryWithFields((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialIntersectsCartesianSourceAndSourceEvaluator.Factory::new)));
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSourceAndConstant(spatialType, otherType), new SpatialEvaluatorFactory.SpatialEvaluatorWithConstantFactory((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, Component2D, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialIntersectsCartesianSourceAndConstantEvaluator.Factory::new)));
                if (!DataType.isSpatialPoint((DataType)spatialType)) continue;
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSources(spatialType, otherType).withLeftDocValues(), new SpatialEvaluatorFactory.SpatialEvaluatorFactoryWithFields((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialIntersectsCartesianPointDocValuesAndSourceEvaluator.Factory::new)));
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSourceAndConstant(spatialType, otherType).withLeftDocValues(), new SpatialEvaluatorFactory.SpatialEvaluatorWithConstantFactory((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, Component2D, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialIntersectsCartesianPointDocValuesAndConstantEvaluator.Factory::new)));
            }
        }
    }
}

