/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.simdvec.internal.vectorization;

import org.apache.lucene.util.BitUtil;
import org.elasticsearch.simdvec.internal.vectorization.ESVectorUtilSupport;

final class DefaultESVectorUtilSupport
implements ESVectorUtilSupport {
    DefaultESVectorUtilSupport() {
    }

    @Override
    public long ipByteBinByte(byte[] q, byte[] d) {
        return DefaultESVectorUtilSupport.ipByteBinByteImpl(q, d);
    }

    public static long ipByteBinByteImpl(byte[] q, byte[] d) {
        long ret = 0L;
        int size = d.length;
        for (int i = 0; i < 4; ++i) {
            int r;
            long subRet = 0L;
            int upperBound = d.length & 0xFFFFFFFC;
            for (r = 0; r < upperBound; r += 4) {
                subRet += (long)Integer.bitCount(BitUtil.VH_NATIVE_INT.get(q, i * size + r) & BitUtil.VH_NATIVE_INT.get(d, r));
            }
            while (r < d.length) {
                subRet += (long)Integer.bitCount(q[i * size + r] & d[r] & 0xFF);
                ++r;
            }
            ret += subRet << i;
        }
        return ret;
    }
}

