/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.convex.ConvexSolver;
import org.ojalgo.structure.Access2D;

abstract class ConstrainedSolver
extends ConvexSolver {
    private final Primitive64Store mySlackE;
    private final Primitive64Store mySolutionL;

    protected ConstrainedSolver(ConvexSolver.Builder matrices, Optimisation.Options solverOptions) {
        super(matrices, solverOptions);
        int numberOfEqualityConstraints = this.countEqualityConstraints();
        int numberOfInequalityConstraints = this.countInequalityConstraints();
        this.mySlackE = (Primitive64Store)Primitive64Store.FACTORY.make((long)numberOfEqualityConstraints, 1L);
        this.mySolutionL = (Primitive64Store)Primitive64Store.FACTORY.make((long)(numberOfEqualityConstraints + numberOfInequalityConstraints), 1L);
    }

    @Override
    protected Optimisation.Result buildResult() {
        Optimisation.Result result = super.buildResult();
        result.multipliers(this.mySolutionL);
        return result;
    }

    @Override
    protected final Access2D.Collectable<Double, ? super PhysicalStore<Double>> getIterationKKT() {
        PhysicalStore<Double> iterQ = this.getIterationQ();
        MatrixStore<Double> iterA = this.getIterationA();
        return iterQ.right(iterA.transpose()).below((Access2D<Double>)iterA);
    }

    @Override
    protected final Access2D.Collectable<Double, ? super PhysicalStore<Double>> getIterationRHS() {
        MatrixStore<Double> iterC = this.getIterationC();
        MatrixStore<Double> iterB = this.getIterationB();
        return iterC.below((Access2D<Double>)iterB);
    }

    @Override
    protected boolean initialise(Optimisation.Result kickStarter) {
        MatrixStore<Double> iterationA;
        boolean spdQ = super.initialise(kickStarter);
        if (this.options.validate && (iterationA = this.getIterationA()) != null) {
            this.computeGeneral((Access2D.Collectable<Double, ? super PhysicalStore<Double>>)((Object)(iterationA.countRows() < iterationA.countColumns() ? iterationA.transpose() : iterationA)));
            if ((long)this.getRankGeneral() != iterationA.countRows()) {
                this.setState(Optimisation.State.INVALID);
                if (!this.isLogDebug()) {
                    throw new IllegalArgumentException("A not full (row) rank!");
                }
                this.log("A not full (row) rank!", new Object[0]);
            }
        }
        return spdQ;
    }

    abstract int countIterationConstraints();

    abstract MatrixStore<Double> getIterationA();

    abstract MatrixStore<Double> getIterationB();

    abstract MatrixStore<Double> getIterationC();

    MatrixStore<Double> getIterationL(int[] included) {
        int tmpCountE = this.countEqualityConstraints();
        MatrixStore tmpLI = (MatrixStore)this.mySolutionL.offsets(tmpCountE, 0L).row(included);
        return this.mySolutionL.limits(tmpCountE, 1L).below(tmpLI);
    }

    final PhysicalStore<Double> getIterationQ() {
        return this.getMatrixQ();
    }

    PhysicalStore<Double> getSlackE() {
        MatrixStore<Double> mtrxAE = this.getMatrixAE();
        MatrixStore<Double> mtrxBE = this.getMatrixBE();
        PhysicalStore<Double> mtrxX = this.getSolutionX();
        if (mtrxAE != null && mtrxAE.count() != 0L) {
            mtrxX.premultiply(mtrxAE).onMatching(mtrxBE, (BinaryFunction)PrimitiveMath.SUBTRACT).supplyTo(this.mySlackE);
        }
        return this.mySlackE;
    }

    Primitive64Store getSolutionL() {
        return this.mySolutionL;
    }
}

