/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.matrix.Matrix2D;
import org.ojalgo.matrix.decomposition.HessenbergDecomposition;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.structure.Access2D;
import org.ojalgo.type.context.NumberContext;

public interface Hessenberg<N extends Comparable<N>>
extends MatrixDecomposition<N> {
    public static final Factory<ComplexNumber> COMPLEX = typical -> new HessenbergDecomposition.Complex();
    public static final Factory<Double> PRIMITIVE = typical -> new HessenbergDecomposition.Primitive();
    public static final Factory<Quaternion> QUATERNION = typical -> new HessenbergDecomposition.Quat();
    public static final Factory<RationalNumber> RATIONAL = typical -> new HessenbergDecomposition.Rational();

    public static <N extends Comparable<N>> boolean equals(MatrixStore<N> matrix, Hessenberg<N> decomposition, NumberContext context) {
        MatrixStore<N> tmpH = decomposition.getH();
        MatrixStore<MatrixStore<N>> tmpQ = decomposition.getQ();
        MatrixStore<MatrixStore<N>> tmpStore1 = matrix.multiply(tmpQ);
        MatrixStore<MatrixStore<N>> tmpStore2 = tmpQ.multiply(tmpH);
        return Access2D.equals(tmpStore1, tmpStore2, context);
    }

    public boolean compute(Access2D.Collectable<N, ? super PhysicalStore<N>> var1, boolean var2);

    public MatrixStore<N> getH();

    public MatrixStore<N> getQ();

    public boolean isUpper();

    @Override
    default public MatrixStore<N> reconstruct() {
        MatrixStore<MatrixStore<N>> mtrxQ = this.getQ();
        MatrixStore<N> mtrxH = this.getH();
        return mtrxQ.multiply(mtrxH).multiply((MatrixStore<Matrix2D>)mtrxQ.transpose());
    }

    public static interface Factory<N extends Comparable<N>>
    extends MatrixDecomposition.Factory<Hessenberg<N>> {
    }
}

