/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.store;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.xpack.core.security.authz.store.ReservedRolesStore;

public final class RoleKey {
    public static final String ROLES_STORE_SOURCE = "roles_stores";
    public static final RoleKey ROLE_KEY_EMPTY = new RoleKey(Set.of(), "__empty_role");
    public static final RoleKey ROLE_KEY_SUPERUSER = new RoleKey(Set.of(ReservedRolesStore.SUPERUSER_ROLE_DESCRIPTOR.getName()), "roles_stores");
    private final Set<String> names;
    private final String source;

    public RoleKey(Set<String> names, String source) {
        this.names = Objects.requireNonNull(names);
        this.source = Objects.requireNonNull(source);
    }

    public Set<String> getNames() {
        return this.names;
    }

    public String getSource() {
        return this.source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoleKey roleKey = (RoleKey)o;
        return this.names.equals(roleKey.names) && this.source.equals(roleKey.source);
    }

    public int hashCode() {
        return Objects.hash(this.names, this.source);
    }

    public String toString() {
        return "RoleKey{names=" + String.valueOf(this.names) + ", source='" + this.source + "'}";
    }
}

