/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.preprocessing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.LenientlyParsedPreProcessor;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.PreProcessor;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.StrictlyParsedPreProcessor;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObjectHelper;

public class Multi
implements LenientlyParsedPreProcessor,
StrictlyParsedPreProcessor {
    public static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(Multi.class);
    public static final ParseField NAME = new ParseField("multi_encoding", new String[0]);
    public static final ParseField PROCESSORS = new ParseField("processors", new String[0]);
    public static final ParseField CUSTOM = new ParseField("custom", new String[0]);
    private static final ObjectParser<Builder, PreProcessor.PreProcessorParseContext> STRICT_PARSER = Multi.createParser(false);
    private static final ObjectParser<Builder, PreProcessor.PreProcessorParseContext> LENIENT_PARSER = Multi.createParser(true);
    private final PreProcessor[] processors;
    private final boolean custom;
    private final Map<String, String> outputFields;
    private final String[] inputFields;

    private static ObjectParser<Builder, PreProcessor.PreProcessorParseContext> createParser(boolean lenient) {
        ObjectParser parser = new ObjectParser(NAME.getPreferredName(), lenient, Builder::new);
        parser.declareNamedObjects(Builder::setProcessors, (p, c, n) -> lenient ? (PreProcessor)p.namedObject(LenientlyParsedPreProcessor.class, n, (Object)PreProcessor.PreProcessorParseContext.DEFAULT) : (PreProcessor)p.namedObject(StrictlyParsedPreProcessor.class, n, (Object)PreProcessor.PreProcessorParseContext.DEFAULT), multiBuilder -> multiBuilder.setOrdered(true), PROCESSORS);
        parser.declareBoolean(Builder::setCustom, CUSTOM);
        return parser;
    }

    public static Multi fromXContentStrict(XContentParser parser, PreProcessor.PreProcessorParseContext context) {
        return ((Builder)STRICT_PARSER.apply(parser, (Object)(context == null ? PreProcessor.PreProcessorParseContext.DEFAULT : context))).build();
    }

    public static Multi fromXContentLenient(XContentParser parser, PreProcessor.PreProcessorParseContext context) {
        return ((Builder)LENIENT_PARSER.apply(parser, (Object)(context == null ? PreProcessor.PreProcessorParseContext.DEFAULT : context))).build();
    }

    public Multi(PreProcessor[] processors, Boolean custom) {
        this.processors = ExceptionsHelper.requireNonNull(processors, PROCESSORS);
        if (this.processors.length < 2) {
            throw new IllegalArgumentException("processors must be an array of objects with at least length 2");
        }
        this.custom = custom != null && custom != false;
        HashSet<String> consumedOutputFields = new HashSet<String>();
        ArrayList<String> inputFields = new ArrayList<String>(processors[0].inputFields());
        LinkedHashMap<String, String> originatingOutputFields = new LinkedHashMap<String, String>();
        for (String outputField : processors[0].outputFields()) {
            originatingOutputFields.put(outputField, processors[0].getOutputFieldType(outputField));
        }
        for (int i = 1; i < processors.length; ++i) {
            PreProcessor processor = processors[i];
            for (String inputField : processor.inputFields()) {
                if (!originatingOutputFields.containsKey(inputField)) {
                    inputFields.add(inputField);
                    continue;
                }
                consumedOutputFields.add(inputField);
            }
            for (String outputField : processor.outputFields()) {
                originatingOutputFields.put(outputField, processor.getOutputFieldType(outputField));
            }
        }
        LinkedHashMap<String, String> outputFields = new LinkedHashMap<String, String>();
        for (Map.Entry outputField : originatingOutputFields.entrySet()) {
            if (consumedOutputFields.contains(outputField.getKey())) continue;
            outputFields.put((String)outputField.getKey(), (String)outputField.getValue());
        }
        this.outputFields = outputFields;
        this.inputFields = (String[])inputFields.toArray(String[]::new);
        if (!this.custom && this.inputFields.length > 1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "[custom] cannot be false as [%s] is unable to accurately determine field reverse encoding for input fields [%s] and output fields %s", NAME.getPreferredName(), Strings.arrayToCommaDelimitedString((Object[])this.inputFields), this.outputFields.keySet()));
        }
    }

    public Multi(StreamInput in) throws IOException {
        this.processors = (PreProcessor[])in.readNamedWriteableCollectionAsList(PreProcessor.class).toArray(PreProcessor[]::new);
        this.custom = in.readBoolean();
        this.outputFields = in.readOrderedMap(StreamInput::readString, StreamInput::readString);
        this.inputFields = in.readStringArray();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteableCollection(Arrays.asList(this.processors));
        out.writeBoolean(this.custom);
        out.writeMap(this.outputFields, StreamOutput::writeString);
        out.writeStringArray(this.inputFields);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    @Override
    public List<String> inputFields() {
        return Arrays.asList(this.inputFields);
    }

    @Override
    public List<String> outputFields() {
        return new ArrayList<String>(this.outputFields.keySet());
    }

    @Override
    public void process(Map<String, Object> fields) {
        for (PreProcessor processor : this.processors) {
            processor.process(fields);
        }
    }

    @Override
    public Map<String, String> reverseLookup() {
        if (this.inputFields.length > 1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] is unable to accurately determine field reverse encoding for input fields [%s] and output fields %s", NAME.getPreferredName(), Strings.arrayToCommaDelimitedString((Object[])this.inputFields), this.outputFields.keySet()));
        }
        return this.outputFields.keySet().stream().collect(Collectors.toMap(Function.identity(), _unused -> this.inputFields[0]));
    }

    @Override
    public String getOutputFieldType(String outputField) {
        return this.outputFields.get(outputField);
    }

    public long ramBytesUsed() {
        long size = SHALLOW_SIZE;
        size += RamUsageEstimator.sizeOf((Accountable[])this.processors);
        size += RamUsageEstimator.sizeOf((String[])this.inputFields);
        return size += RamUsageEstimator.sizeOfMap(this.outputFields, (long)0L);
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        NamedXContentObjectHelper.writeNamedObjects(builder, params, true, PROCESSORS.getPreferredName(), Arrays.asList(this.processors));
        builder.field(CUSTOM.getPreferredName(), this.custom);
        builder.endObject();
        return builder;
    }

    @Override
    public boolean isCustom() {
        return this.custom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Multi multi = (Multi)o;
        return Arrays.equals(multi.processors, this.processors) && this.custom == multi.custom;
    }

    public int hashCode() {
        return Objects.hash(this.custom, Arrays.hashCode(this.processors));
    }

    static class Builder {
        private boolean ordered;
        private List<PreProcessor> processors;
        private boolean custom;

        Builder() {
        }

        public Builder setOrdered(boolean ordered) {
            this.ordered = ordered;
            return this;
        }

        public Builder setProcessors(List<PreProcessor> processors) {
            this.processors = processors;
            return this;
        }

        public Builder setCustom(boolean custom) {
            this.custom = custom;
            return this;
        }

        Multi build() {
            if (!this.ordered) {
                throw new IllegalArgumentException("processors must be an array of objects");
            }
            if (this.processors.size() < 2) {
                throw new IllegalArgumentException("processors must be an array of objects with at least length 2");
            }
            return new Multi((PreProcessor[])this.processors.toArray(PreProcessor[]::new), this.custom);
        }
    }
}

