/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.datastreams;

import java.io.IOException;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureUsage;

public class DataStreamLifecycleFeatureSetUsage
extends XPackFeatureUsage {
    public static final DataStreamLifecycleFeatureSetUsage DISABLED = new DataStreamLifecycleFeatureSetUsage();
    final LifecycleStats lifecycleStats;

    public DataStreamLifecycleFeatureSetUsage(StreamInput input) throws IOException {
        super(input);
        this.lifecycleStats = LifecycleStats.read(input);
    }

    private DataStreamLifecycleFeatureSetUsage() {
        super("data_lifecycle", true, false);
        this.lifecycleStats = LifecycleStats.INITIAL;
    }

    public DataStreamLifecycleFeatureSetUsage(LifecycleStats stats) {
        super("data_lifecycle", true, true);
        this.lifecycleStats = stats;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.lifecycleStats.writeTo(out);
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_9_X;
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        if (this.enabled) {
            this.lifecycleStats.toXContent(builder, params);
        }
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public int hashCode() {
        return Objects.hash(this.available, this.enabled, this.lifecycleStats);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DataStreamLifecycleFeatureSetUsage other = (DataStreamLifecycleFeatureSetUsage)obj;
        return this.available == other.available && this.enabled == other.enabled && Objects.equals(this.lifecycleStats, other.lifecycleStats);
    }

    public static class LifecycleStats
    implements Writeable,
    ToXContentFragment {
        public static final LifecycleStats INITIAL = new LifecycleStats(0L, true, RetentionStats.NO_DATA, RetentionStats.NO_DATA, Map.of());
        public static final String DEFAULT_RETENTION_FIELD_NAME = "default";
        public static final String MAX_RETENTION_FIELD_NAME = "max";
        final long dataStreamsWithLifecyclesCount;
        final boolean defaultRolloverUsed;
        final RetentionStats dataRetentionStats;
        final RetentionStats effectiveRetentionStats;
        final Map<String, GlobalRetentionStats> globalRetentionStats;

        public LifecycleStats(long dataStreamsWithLifecyclesCount, boolean defaultRolloverUsed, RetentionStats dataRetentionStats, RetentionStats effectiveRetentionStats, Map<String, GlobalRetentionStats> globalRetentionStats) {
            this.dataStreamsWithLifecyclesCount = dataStreamsWithLifecyclesCount;
            this.defaultRolloverUsed = defaultRolloverUsed;
            this.dataRetentionStats = dataRetentionStats;
            this.effectiveRetentionStats = effectiveRetentionStats;
            this.globalRetentionStats = globalRetentionStats;
        }

        public static LifecycleStats read(StreamInput in) throws IOException {
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.GLOBAL_RETENTION_TELEMETRY)) {
                return new LifecycleStats(in.readVLong(), in.readBoolean(), RetentionStats.read(in), RetentionStats.read(in), in.readMap(GlobalRetentionStats::new));
            }
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_9_X)) {
                long dataStreamsWithLifecyclesCount = in.readVLong();
                long minDataRetention = in.readVLong();
                long maxDataRetention = in.readVLong();
                double avgDataRetention = in.readDouble();
                boolean defaultRolledOverUsed = in.readBoolean();
                return new LifecycleStats(dataStreamsWithLifecyclesCount, defaultRolledOverUsed, new RetentionStats(dataStreamsWithLifecyclesCount, avgDataRetention, minDataRetention, maxDataRetention), RetentionStats.NO_DATA, Map.of());
            }
            return INITIAL;
        }

        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.GLOBAL_RETENTION_TELEMETRY)) {
                out.writeVLong(this.dataStreamsWithLifecyclesCount);
                out.writeBoolean(this.defaultRolloverUsed);
                this.dataRetentionStats.writeTo(out);
                this.effectiveRetentionStats.writeTo(out);
                out.writeMap(this.globalRetentionStats, (o, v) -> v.writeTo(o));
            } else if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_9_X)) {
                out.writeVLong(this.dataStreamsWithLifecyclesCount);
                out.writeVLong(this.dataRetentionStats.minMillis() == null ? 0L : this.dataRetentionStats.minMillis());
                out.writeVLong(this.dataRetentionStats.maxMillis() == null ? 0L : this.dataRetentionStats.maxMillis());
                out.writeDouble(this.dataRetentionStats.avgMillis() == null ? 0.0 : this.dataRetentionStats.avgMillis());
                out.writeBoolean(this.defaultRolloverUsed);
            }
        }

        public int hashCode() {
            return Objects.hash(this.dataStreamsWithLifecyclesCount, this.defaultRolloverUsed, this.dataRetentionStats, this.effectiveRetentionStats, this.globalRetentionStats);
        }

        public boolean equals(Object obj) {
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            LifecycleStats other = (LifecycleStats)obj;
            return this.dataStreamsWithLifecyclesCount == other.dataStreamsWithLifecyclesCount && this.defaultRolloverUsed == other.defaultRolloverUsed && Objects.equals(this.dataRetentionStats, other.dataRetentionStats) && Objects.equals(this.effectiveRetentionStats, other.effectiveRetentionStats) && Objects.equals(this.globalRetentionStats, other.globalRetentionStats);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("count", this.dataStreamsWithLifecyclesCount);
            builder.field("default_rollover_used", this.defaultRolloverUsed);
            builder.startObject("data_retention");
            builder.field("configured_data_streams", this.dataRetentionStats.dataStreamCount());
            if (this.dataRetentionStats.dataStreamCount() > 0L) {
                builder.field("minimum_millis", this.dataRetentionStats.minMillis);
                builder.field("maximum_millis", this.dataRetentionStats.maxMillis);
                builder.field("average_millis", this.dataRetentionStats.avgMillis);
            }
            builder.endObject();
            builder.startObject("effective_retention");
            builder.field("retained_data_streams", this.effectiveRetentionStats.dataStreamCount());
            if (this.effectiveRetentionStats.dataStreamCount() > 0L) {
                builder.field("minimum_millis", this.effectiveRetentionStats.minMillis);
                builder.field("maximum_millis", this.effectiveRetentionStats.maxMillis);
                builder.field("average_millis", this.effectiveRetentionStats.avgMillis);
            }
            builder.endObject();
            builder.startObject("global_retention");
            this.globalRetentionStatsToXContent(builder, params, DEFAULT_RETENTION_FIELD_NAME);
            this.globalRetentionStatsToXContent(builder, params, MAX_RETENTION_FIELD_NAME);
            builder.endObject();
            return builder;
        }

        private void globalRetentionStatsToXContent(XContentBuilder builder, ToXContent.Params params, String retentionType) throws IOException {
            builder.startObject(retentionType);
            GlobalRetentionStats stats = this.globalRetentionStats.get(retentionType);
            builder.field("defined", stats != null);
            if (stats != null) {
                builder.field("affected_data_streams", stats.dataStreamCount());
                builder.field("retention_millis", stats.retention());
            }
            builder.endObject();
        }
    }

    public record GlobalRetentionStats(long dataStreamCount, long retention) implements Writeable
    {
        public GlobalRetentionStats(long dataStreamCount, TimeValue retention) {
            this(dataStreamCount, retention.getMillis());
        }

        public GlobalRetentionStats(StreamInput in) throws IOException {
            this(in.readVLong(), in.readVLong());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.dataStreamCount);
            out.writeVLong(this.retention);
        }
    }

    public record RetentionStats(long dataStreamCount, Double avgMillis, Long minMillis, Long maxMillis) implements Writeable
    {
        static final RetentionStats NO_DATA = new RetentionStats(0L, null, null, null);

        public static RetentionStats create(LongSummaryStatistics statistics) {
            if (statistics.getCount() == 0L) {
                return NO_DATA;
            }
            return new RetentionStats(statistics.getCount(), statistics.getAverage(), statistics.getMin(), statistics.getMax());
        }

        public static RetentionStats read(StreamInput in) throws IOException {
            long dataStreamCount = in.readVLong();
            if (dataStreamCount == 0L) {
                return NO_DATA;
            }
            double avgMillis = in.readDouble();
            long minMillis = in.readVLong();
            long maxMillis = in.readVLong();
            return new RetentionStats(dataStreamCount, avgMillis, minMillis, maxMillis);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.dataStreamCount);
            if (this.dataStreamCount > 0L) {
                out.writeDouble(this.avgMillis.doubleValue());
                out.writeVLong(this.minMillis.longValue());
                out.writeVLong(this.maxMillis.longValue());
            }
        }
    }
}

