/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;

final class BytesRefLookup
implements ReleasableIterator<BytesRefBlock> {
    private final BytesRef firstScratch = new BytesRef();
    private final BytesRef valueScratch = new BytesRef();
    private final BytesRefBlock values;
    private final IntBlock positions;
    private final long targetByteSize;
    private int position;
    private BytesRef first;
    private int valuesInPosition;

    BytesRefLookup(BytesRefBlock values, IntBlock positions, ByteSizeValue targetBlockSize) {
        values.incRef();
        positions.incRef();
        this.values = values;
        this.positions = positions;
        this.targetByteSize = targetBlockSize.getBytes();
    }

    public boolean hasNext() {
        return this.position < this.positions.getPositionCount();
    }

    public BytesRefBlock next() {
        try (BytesRefBlock.Builder builder = this.positions.blockFactory().newBytesRefBlockBuilder(this.positions.getTotalValueCount());){
            int count = 0;
            while (this.position < this.positions.getPositionCount()) {
                int start = this.positions.getFirstValueIndex(this.position);
                int end = start + this.positions.getValueCount(this.position);
                this.valuesInPosition = 0;
                for (int i = start; i < end; ++i) {
                    this.copy(builder, this.positions.getInt(i));
                }
                switch (this.valuesInPosition) {
                    case 0: {
                        builder.appendNull();
                        break;
                    }
                    case 1: {
                        builder.appendBytesRef(this.first);
                        break;
                    }
                    default: {
                        builder.endPositionEntry();
                    }
                }
                ++this.position;
                if (++count <= 32 || builder.estimatedBytes() >= this.targetByteSize) continue;
                break;
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    private void copy(BytesRefBlock.Builder builder, int valuePosition) {
        if (valuePosition >= this.values.getPositionCount()) {
            return;
        }
        int start = this.values.getFirstValueIndex(valuePosition);
        int end = start + this.values.getValueCount(valuePosition);
        for (int i = start; i < end; ++i) {
            if (this.valuesInPosition == 0) {
                this.first = this.values.getBytesRef(i, this.firstScratch);
                ++this.valuesInPosition;
                continue;
            }
            if (this.valuesInPosition == 1) {
                builder.beginPositionEntry();
                builder.appendBytesRef(this.first);
            }
            if ((long)this.valuesInPosition > 100000L) {
                throw new IllegalArgumentException("Found a single entry with " + this.valuesInPosition + " entries");
            }
            builder.appendBytesRef(this.values.getBytesRef(i, this.valueScratch));
            ++this.valuesInPosition;
        }
    }

    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.values, this.positions});
    }
}

