/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.BooleanArrayBlock;
import org.elasticsearch.compute.data.BooleanBigArrayBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.ToMask;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.index.mapper.BlockLoader;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface BooleanBlock
extends Block {
    public static final NamedWriteableRegistry.Entry ENTRY;

    public boolean getBoolean(int var1);

    @Override
    public BooleanVector asVector();

    public ToMask toMask();

    @Override
    public BooleanBlock filter(int ... var1);

    @Override
    public BooleanBlock keepMask(BooleanVector var1);

    public ReleasableIterator<? extends BooleanBlock> lookup(IntBlock var1, ByteSizeValue var2);

    @Override
    public BooleanBlock expand();

    default public String getWriteableName() {
        return "BooleanBlock";
    }

    private static BooleanBlock readFrom(StreamInput in) throws IOException {
        return BooleanBlock.readFrom((BlockStreamInput)in);
    }

    public static BooleanBlock readFrom(BlockStreamInput in) throws IOException {
        byte serializationType = in.readByte();
        return switch (serializationType) {
            case 0 -> BooleanBlock.readValues(in);
            case 1 -> BooleanVector.readFrom(in.blockFactory(), (StreamInput)in).asBlock();
            case 2 -> BooleanArrayBlock.readArrayBlock(in.blockFactory(), in);
            case 3 -> BooleanBigArrayBlock.readArrayBlock(in.blockFactory(), in);
            default -> {
                if (!1.$assertionsDisabled) {
                    throw new AssertionError((Object)("invalid block serialization type " + serializationType));
                }
                throw new IllegalStateException("invalid serialization type " + serializationType);
            }
        };
    }

    private static BooleanBlock readValues(BlockStreamInput in) throws IOException {
        int positions = in.readVInt();
        try (Builder builder = in.blockFactory().newBooleanBlockBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                if (in.readBoolean()) {
                    builder.appendNull();
                    continue;
                }
                int valueCount = in.readVInt();
                builder.beginPositionEntry();
                for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                    builder.appendBoolean(in.readBoolean());
                }
                builder.endPositionEntry();
            }
            BooleanBlock booleanBlock = builder.build();
            return booleanBlock;
        }
    }

    default public void writeTo(StreamOutput out) throws IOException {
        BooleanBlock booleanBlock;
        BooleanVector vector = this.asVector();
        TransportVersion version = out.getTransportVersion();
        if (vector != null) {
            out.writeByte((byte)1);
            vector.writeTo(out);
        } else if (version.onOrAfter((VersionId)TransportVersions.V_8_14_0) && (booleanBlock = this) instanceof BooleanArrayBlock) {
            BooleanArrayBlock b = (BooleanArrayBlock)booleanBlock;
            out.writeByte((byte)2);
            b.writeArrayBlock(out);
        } else if (version.onOrAfter((VersionId)TransportVersions.V_8_14_0) && (booleanBlock = this) instanceof BooleanBigArrayBlock) {
            BooleanBigArrayBlock b = (BooleanBigArrayBlock)booleanBlock;
            out.writeByte((byte)3);
            b.writeArrayBlock(out);
        } else {
            out.writeByte((byte)0);
            BooleanBlock.writeValues(this, out);
        }
    }

    private static void writeValues(BooleanBlock block, StreamOutput out) throws IOException {
        int positions = block.getPositionCount();
        out.writeVInt(positions);
        for (int pos = 0; pos < positions; ++pos) {
            if (block.isNull(pos)) {
                out.writeBoolean(true);
                continue;
            }
            out.writeBoolean(false);
            int valueCount = block.getValueCount(pos);
            out.writeVInt(valueCount);
            for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                out.writeBoolean(block.getBoolean(block.getFirstValueIndex(pos) + valueIndex));
            }
        }
    }

    public boolean equals(Object var1);

    public int hashCode();

    public static boolean equals(BooleanBlock block1, BooleanBlock block2) {
        if (block1 == block2) {
            return true;
        }
        int positions = block1.getPositionCount();
        if (positions != block2.getPositionCount()) {
            return false;
        }
        for (int pos = 0; pos < positions; ++pos) {
            if (block1.isNull(pos) || block2.isNull(pos)) {
                if (block1.isNull(pos) == block2.isNull(pos)) continue;
                return false;
            }
            int valueCount = block1.getValueCount(pos);
            if (valueCount != block2.getValueCount(pos)) {
                return false;
            }
            int b1ValueIdx = block1.getFirstValueIndex(pos);
            int b2ValueIdx = block2.getFirstValueIndex(pos);
            for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                if (block1.getBoolean(b1ValueIdx + valueIndex) == block2.getBoolean(b2ValueIdx + valueIndex)) continue;
                return false;
            }
        }
        return true;
    }

    public static int hash(BooleanBlock block) {
        int positions = block.getPositionCount();
        int result = 1;
        for (int pos = 0; pos < positions; ++pos) {
            if (block.isNull(pos)) {
                result = 31 * result - 1;
                continue;
            }
            int valueCount = block.getValueCount(pos);
            result = 31 * result + valueCount;
            int firstValueIdx = block.getFirstValueIndex(pos);
            for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                result = 31 * result + Boolean.hashCode(block.getBoolean(firstValueIdx + valueIndex));
            }
        }
        return result;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        ENTRY = new NamedWriteableRegistry.Entry(Block.class, "BooleanBlock", BooleanBlock::readFrom);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Builder
    extends Block.Builder,
    BlockLoader.BooleanBuilder {
        public Builder appendBoolean(boolean var1);

        public Builder copyFrom(BooleanBlock var1, int var2, int var3);

        @Override
        public Builder appendNull();

        @Override
        public Builder beginPositionEntry();

        @Override
        public Builder endPositionEntry();

        @Override
        public Builder copyFrom(Block var1, int var2, int var3);

        @Override
        public Builder mvOrdering(Block.MvOrdering var1);

        @Override
        public BooleanBlock build();
    }
}

