/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.blockhash;

import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.common.util.LongLongHash;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;

public final class TimeSeriesBlockHash
extends BlockHash {
    private final int tsHashChannel;
    private final int timestampIntervalChannel;
    private final BytesRefHash tsidHashes;
    private final LongLongHash intervalHash;
    long groupOrdinal = -1L;
    BytesRef previousTsidHash;
    long previousTimestampInterval;

    public TimeSeriesBlockHash(int tsHashChannel, int timestampIntervalChannel, DriverContext driverContext) {
        super(driverContext.blockFactory());
        this.tsHashChannel = tsHashChannel;
        this.timestampIntervalChannel = timestampIntervalChannel;
        this.tsidHashes = new BytesRefHash(1L, this.blockFactory.bigArrays());
        this.intervalHash = new LongLongHash(1L, this.blockFactory.bigArrays());
    }

    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.tsidHashes, this.intervalHash});
    }

    @Override
    public void add(Page page, GroupingAggregatorFunction.AddInput addInput) {
        BytesRefBlock tsHashBlock = (BytesRefBlock)page.getBlock(this.tsHashChannel);
        BytesRefVector tsHashVector = Objects.requireNonNull(tsHashBlock.asVector());
        try (IntVector.Builder ordsBuilder = this.blockFactory.newIntVectorBuilder(tsHashVector.getPositionCount());){
            LongBlock timestampIntervalBlock = (LongBlock)page.getBlock(this.timestampIntervalChannel);
            BytesRef spare = new BytesRef();
            for (int i = 0; i < tsHashVector.getPositionCount(); ++i) {
                BytesRef tsHash = tsHashVector.getBytesRef(i, spare);
                long timestampInterval = timestampIntervalBlock.getLong(i);
                if (!tsHash.equals((Object)this.previousTsidHash) || timestampInterval != this.previousTimestampInterval) {
                    long tsidOrdinal = this.tsidHashes.add(tsHash);
                    if (tsidOrdinal < 0L) {
                        tsidOrdinal = -1L - tsidOrdinal;
                    }
                    this.groupOrdinal = this.intervalHash.add(tsidOrdinal, timestampInterval);
                    if (this.groupOrdinal < 0L) {
                        this.groupOrdinal = -1L - this.groupOrdinal;
                    }
                    this.previousTsidHash = BytesRef.deepCopyOf((BytesRef)tsHash);
                    this.previousTimestampInterval = timestampInterval;
                }
                ordsBuilder.appendInt(Math.toIntExact(this.groupOrdinal));
            }
            try (IntVector ords = ordsBuilder.build();){
                addInput.add(0, ords);
            }
        }
    }

    @Override
    public ReleasableIterator<IntBlock> lookup(Page page, ByteSizeValue targetBlockSize) {
        throw new UnsupportedOperationException("TODO");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Block[] getKeys() {
        int positions = (int)this.intervalHash.size();
        BytesRefVector tsidHashes = null;
        LongVector timestampIntervals = null;
        try {
            try (BytesRefVector.Builder tsidHashesBuilder = this.blockFactory.newBytesRefVectorBuilder(positions);
                 LongVector.FixedBuilder timestampIntervalsBuilder = this.blockFactory.newLongVectorFixedBuilder(positions);){
                BytesRef scratch = new BytesRef();
                for (long i = 0L; i < (long)positions; ++i) {
                    BytesRef key1 = this.tsidHashes.get(this.intervalHash.getKey1(i), scratch);
                    tsidHashesBuilder.appendBytesRef(key1);
                    timestampIntervalsBuilder.appendLong((int)i, this.intervalHash.getKey2(i));
                }
                tsidHashes = tsidHashesBuilder.build();
                timestampIntervals = timestampIntervalsBuilder.build();
            }
            if (timestampIntervals != null) return new Block[]{tsidHashes.asBlock(), timestampIntervals.asBlock()};
        }
        catch (Throwable throwable) {
            if (timestampIntervals != null) throw throwable;
            Releasables.closeExpectNoException(tsidHashes);
            throw throwable;
        }
        Releasables.closeExpectNoException((Releasable)tsidHashes);
        return new Block[]{tsidHashes.asBlock(), timestampIntervals.asBlock()};
    }

    @Override
    public IntVector nonEmpty() {
        long endExclusive = this.intervalHash.size();
        return IntVector.range(0, Math.toIntExact(endExclusive), this.blockFactory);
    }

    @Override
    public BitArray seenGroupIds(BigArrays bigArrays) {
        long size = this.intervalHash.size();
        return new SeenGroupIds.Range(0, Math.toIntExact(size)).seenGroupIds(bigArrays);
    }

    public String toString() {
        return "TimeSeriesBlockHash{keys=[BytesRefKey[channel=" + this.tsHashChannel + "], LongKey[channel=" + this.timestampIntervalChannel + "]], entries=" + this.groupOrdinal + "b}";
    }
}

