/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.blockhash;

import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.mvdedupe.MultivalueDedupeBoolean;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;

final class BooleanBlockHash
extends BlockHash {
    private final int channel;
    private final boolean[] everSeen = new boolean[3];

    BooleanBlockHash(int channel, BlockFactory blockFactory) {
        super(blockFactory);
        this.channel = channel;
    }

    @Override
    public void add(Page page, GroupingAggregatorFunction.AddInput addInput) {
        Object block = page.getBlock(this.channel);
        if (block.areAllValuesNull()) {
            this.everSeen[0] = true;
            try (IntVector groupIds = this.blockFactory.newConstantIntVector(0, block.getPositionCount());){
                addInput.add(0, groupIds);
            }
        }
        BooleanBlock booleanBlock = (BooleanBlock)page.getBlock(this.channel);
        BooleanVector booleanVector = booleanBlock.asVector();
        if (booleanVector == null) {
            try (IntBlock groupIds = this.add(booleanBlock);){
                addInput.add(0, groupIds);
            }
        }
        try (IntVector groupIds = this.add(booleanVector);){
            addInput.add(0, groupIds);
        }
    }

    private IntVector add(BooleanVector vector) {
        int positions = vector.getPositionCount();
        try (IntVector.FixedBuilder builder = this.blockFactory.newIntVectorFixedBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                builder.appendInt(i, MultivalueDedupeBoolean.hashOrd(this.everSeen, vector.getBoolean(i)));
            }
            IntVector intVector = builder.build();
            return intVector;
        }
    }

    private IntBlock add(BooleanBlock block) {
        return new MultivalueDedupeBoolean(block).hash(this.blockFactory, this.everSeen);
    }

    @Override
    public ReleasableIterator<IntBlock> lookup(Page page, ByteSizeValue targetBlockSize) {
        Object block = page.getBlock(this.channel);
        if (block.areAllValuesNull()) {
            return ReleasableIterator.single((Releasable)this.blockFactory.newConstantIntVector(0, block.getPositionCount()).asBlock());
        }
        BooleanBlock castBlock = (BooleanBlock)page.getBlock(this.channel);
        BooleanVector vector = castBlock.asVector();
        if (vector == null) {
            return ReleasableIterator.single((Releasable)this.lookup(castBlock));
        }
        return ReleasableIterator.single((Releasable)this.lookup(vector));
    }

    private IntBlock lookup(BooleanVector vector) {
        int positions = vector.getPositionCount();
        try (IntBlock.Builder builder = this.blockFactory.newIntBlockBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                int ord;
                boolean v = vector.getBoolean(i);
                int n = ord = v ? 2 : 1;
                if (this.everSeen[ord]) {
                    builder.appendInt(ord);
                    continue;
                }
                builder.appendNull();
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    private IntBlock lookup(BooleanBlock block) {
        return new MultivalueDedupeBoolean(block).hash(this.blockFactory, new boolean[3]);
    }

    public BooleanBlock[] getKeys() {
        try (BooleanBlock.Builder builder = this.blockFactory.newBooleanBlockBuilder(this.everSeen.length);){
            if (this.everSeen[0]) {
                builder.appendNull();
            }
            if (this.everSeen[1]) {
                builder.appendBoolean(false);
            }
            if (this.everSeen[2]) {
                builder.appendBoolean(true);
            }
            BooleanBlock[] booleanBlockArray = new BooleanBlock[]{builder.build()};
            return booleanBlockArray;
        }
    }

    @Override
    public IntVector nonEmpty() {
        try (IntVector.Builder builder = this.blockFactory.newIntVectorBuilder(this.everSeen.length);){
            for (int i = 0; i < this.everSeen.length; ++i) {
                if (!this.everSeen[i]) continue;
                builder.appendInt(i);
            }
            IntVector intVector = builder.build();
            return intVector;
        }
    }

    @Override
    public BitArray seenGroupIds(BigArrays bigArrays) {
        BitArray seen = new BitArray((long)this.everSeen.length, bigArrays);
        for (int i = 0; i < this.everSeen.length; ++i) {
            if (!this.everSeen[i]) continue;
            seen.set((long)i);
        }
        return seen;
    }

    public void close() {
    }

    public String toString() {
        return "BooleanBlockHash{channel=" + this.channel + ", seenFalse=" + this.everSeen[1] + ", seenTrue=" + this.everSeen[2] + ", seenNull=" + this.everSeen[0] + "}";
    }
}

