/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.accesscontrol.wrapper;

import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;

public class DlsFlsFeatureTrackingIndicesAccessControlWrapper {
    private final XPackLicenseState licenseState;
    private final boolean isDlsFlsEnabled;

    public DlsFlsFeatureTrackingIndicesAccessControlWrapper(Settings settings, XPackLicenseState licenseState) {
        this.licenseState = licenseState;
        this.isDlsFlsEnabled = (Boolean)XPackSettings.DLS_FLS_ENABLED.get(settings);
    }

    public IndicesAccessControl wrap(IndicesAccessControl indicesAccessControl) {
        if (!this.isDlsFlsEnabled || indicesAccessControl == null || indicesAccessControl == IndicesAccessControl.ALLOW_NO_INDICES || indicesAccessControl == IndicesAccessControl.DENIED || indicesAccessControl == IndicesAccessControl.allowAll() || indicesAccessControl instanceof DlsFlsFeatureUsageTracker) {
            return indicesAccessControl;
        }
        return new DlsFlsFeatureUsageTracker(indicesAccessControl, this.licenseState);
    }

    private static class DlsFlsFeatureUsageTracker
    extends IndicesAccessControl {
        private final XPackLicenseState licenseState;

        private DlsFlsFeatureUsageTracker(IndicesAccessControl wrapped, XPackLicenseState licenseState) {
            super(wrapped);
            this.licenseState = licenseState;
        }

        public IndicesAccessControl.IndexAccessControl getIndexPermissions(String index) {
            IndicesAccessControl.IndexAccessControl iac = super.getIndexPermissions(index);
            if (iac != null) {
                this.trackUsage(iac);
            }
            return iac;
        }

        private void trackUsage(IndicesAccessControl.IndexAccessControl iac) {
            if (iac.getDocumentPermissions().hasDocumentLevelPermissions()) {
                boolean dlsLicensed = SecurityField.DOCUMENT_LEVEL_SECURITY_FEATURE.check(this.licenseState);
                assert (dlsLicensed) : "DLS feature should be licensed before usage";
            }
            if (iac.getFieldPermissions().hasFieldLevelSecurity()) {
                boolean flsLicensed = SecurityField.FIELD_LEVEL_SECURITY_FEATURE.check(this.licenseState);
                assert (flsLicensed) : "FLS feature should be licensed before usage";
            }
        }
    }
}

