#!/bin/bash
set -ev

if [ "$TRAVIS_REPO_SLUG" == "cyclestreets/android" ] &&[ "$CI" == "true" ] && [ "$TRAVIS_BRANCH" == "master" ] && [ "$TRAVIS_PULL_REQUEST" == "false" ]; then
  echo "Running a non-PR build on master - set up signing info"
  openssl aes-256-cbc -k $openssl_file_encryption_key -in cyclestreets.app/license.properties.enc -out cyclestreets.app/license.properties -d
  openssl aes-256-cbc -k $openssl_file_encryption_key -in cyclestreets.app/signature.asc.enc -out cyclestreets.app/signature.asc -d
  openssl aes-256-cbc -k $openssl_file_encryption_key -in cyclestreets.app/keystore.enc -out cyclestreets.app/keystore -d
  openssl aes-256-cbc -k $openssl_file_encryption_key -in cyclestreets.app/play-api-key.p12.enc -out cyclestreets.app/play-api-key.p12 -d
  openssl aes-256-cbc -k $openssl_file_encryption_key -in libraries/cyclestreets-core/src/test/resources/cyclestreets-api.key.enc -out libraries/cyclestreets-core/src/test/resources/cyclestreets-api.key -d
else
  echo "The compiled artifact will have a dummy signature"
  cp cyclestreets.app/license.properties.dummy cyclestreets.app/license.properties
  cp cyclestreets.app/keystore.dummy cyclestreets.app/keystore
fi
