/*************************************************************************/
/*  concave_polygon_shape_2d.cpp                                         */
/*************************************************************************/
/*                       This file is part of:                           */
/*                           GODOT ENGINE                                */
/*                      https://godotengine.org                          */
/*************************************************************************/
/* Copyright (c) 2007-2017 Juan Linietsky, Ariel Manzur.                 */
/* Copyright (c) 2014-2017 Godot Engine contributors (cf. AUTHORS.md)    */
/*                                                                       */
/* Permission is hereby granted, free of charge, to any person obtaining */
/* a copy of this software and associated documentation files (the       */
/* "Software"), to deal in the Software without restriction, including   */
/* without limitation the rights to use, copy, modify, merge, publish,   */
/* distribute, sublicense, and/or sell copies of the Software, and to    */
/* permit persons to whom the Software is furnished to do so, subject to */
/* the following conditions:                                             */
/*                                                                       */
/* The above copyright notice and this permission notice shall be        */
/* included in all copies or substantial portions of the Software.       */
/*                                                                       */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,       */
/* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF    */
/* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.*/
/* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY  */
/* CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,  */
/* TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE     */
/* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.                */
/*************************************************************************/
#include "concave_polygon_shape_2d.h"

#include "servers/physics_2d_server.h"
#include "servers/visual_server.h"

void ConcavePolygonShape2D::set_segments(const DVector<Vector2> &p_segments) {

	Physics2DServer::get_singleton()->shape_set_data(get_rid(), p_segments);
	emit_changed();
}

DVector<Vector2> ConcavePolygonShape2D::get_segments() const {

	return Physics2DServer::get_singleton()->shape_get_data(get_rid());
}

void ConcavePolygonShape2D::draw(const RID &p_to_rid, const Color &p_color) {

	DVector<Vector2> s = get_segments();
	int len = s.size();
	if (len == 0 || (len % 2) == 1)
		return;

	DVector<Vector2>::Read r = s.read();
	for (int i = 0; i < len; i += 2) {
		VisualServer::get_singleton()->canvas_item_add_line(p_to_rid, r[i], r[i + 1], p_color, 2);
	}
}

Rect2 ConcavePolygonShape2D::get_rect() const {

	DVector<Vector2> s = get_segments();
	int len = s.size();
	if (len == 0)
		return Rect2();

	Rect2 rect;

	DVector<Vector2>::Read r = s.read();
	for (int i = 0; i < len; i++) {
		if (i == 0)
			rect.pos = r[i];
		else
			rect.expand_to(r[i]);
	}

	return rect;
}

void ConcavePolygonShape2D::_bind_methods() {

	ObjectTypeDB::bind_method(_MD("set_segments", "segments"), &ConcavePolygonShape2D::set_segments);
	ObjectTypeDB::bind_method(_MD("get_segments"), &ConcavePolygonShape2D::get_segments);

	ADD_PROPERTY(PropertyInfo(Variant::VECTOR2_ARRAY, "segments"), _SCS("set_segments"), _SCS("get_segments"));
}

ConcavePolygonShape2D::ConcavePolygonShape2D()
	: Shape2D(Physics2DServer::get_singleton()->shape_create(Physics2DServer::SHAPE_CONCAVE_POLYGON)) {
}
