package io.oversec.one.crypto.ui

import android.app.Activity
import android.app.ActivityOptions
import android.content.Context
import android.content.Intent
import android.content.IntentSender
import android.os.Bundle
import android.support.v7.app.AppCompatActivity
import android.support.v7.widget.Toolbar
import android.view.Menu
import android.view.MenuItem
import android.view.View
import io.oversec.one.common.CoreContract
import io.oversec.one.crypto.*
import kotlinx.android.synthetic.main.activity_encryption_info.*
import roboguice.util.Ln

class EncryptionInfoActivity : AppCompatActivity() {
    private var mTdr: BaseDecryptResult? = null
    private var mOrigText: String? = null

    private lateinit var mFragment: AbstractTextEncryptionInfoFragment
    private lateinit var mEncryptionHandler: AbstractCryptoHandler

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        //make sure to clear any pending decrypt tasks in the background, as they might interfere with pending intents generated by the user in the UI thread of this activity
        CryptoHandlerFacade.getInstance(this).clearDecryptQueue()

        setContentView(R.layout.activity_encryption_info)

        mOrigText = intent.getStringExtra(EXTRA_ENCRYPTED_TEXT)
        val mPackageName = intent.getStringExtra(EXTRA_PACKAGENAME)

        val aEncryptionHandler = CryptoHandlerFacade.getInstance(this).getCryptoHandler(mOrigText!!)
        if (aEncryptionHandler == null) {
            finish()
            return
        }

        aEncryptionHandler.let {
            mEncryptionHandler = it;
            mFragment = it.getTextEncryptionInfoFragment(mPackageName)
        }

        mFragment.setArgs(mPackageName)
        val manager = fragmentManager

        val transaction = manager.beginTransaction()
        transaction.replace(R.id.encryptionInfoFragment_container, mFragment, "Foo")
        transaction.commit()

        setSupportActionBar(toolbar)

        supportActionBar!!.setDisplayHomeAsUpEnabled(true)
    }

    override fun onResumeFragments() {
        update(null)
        super.onResumeFragments()
    }

    fun update(actionIntent: Intent?) {
        if (actionIntent == null && mTdr != null) {
            return
        }

        var uix: UserInteractionRequiredException? = null
        try {
            mTdr = CryptoHandlerFacade.getInstance(this).decryptWithLock(mOrigText!!, actionIntent)
        } catch (e: UserInteractionRequiredException) {

            //we might be dealing with a external key, so try to use cached info first
            val atdr = CoreContract.instance!!.getFromEncryptionCache(mOrigText!!)
            if (atdr != null) {
                mTdr = atdr
            } else {
                uix = e
            }
        }

        mFragment.setData(this, mOrigText!!, mTdr, uix, mEncryptionHandler)

    }

    fun update(decryptResult: BaseDecryptResult) {
        mTdr = decryptResult
        mFragment.setData(this, mOrigText!!, decryptResult, null, mEncryptionHandler)

    }

    override fun onCreateOptionsMenu(menu: Menu): Boolean {
        return mFragment.onCreateOptionsMenu(this, menu)
    }

    override fun onPrepareOptionsMenu(menu: Menu): Boolean {
        mFragment.onPrepareOptionsMenu(menu)
        return super.onPrepareOptionsMenu(menu)
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        val id = item.itemId
        if (id == android.R.id.home) {
            finish()
            setupExitTransition()
        } else {
            mFragment.onOptionsItemSelected(this, item)
        }
        return super.onOptionsItemSelected(item)
    }


    override fun onBackPressed() {
        super.onBackPressed()
        setupExitTransition()
    }

    private fun setupExitTransition() {
        overridePendingTransition(0, R.anim.activity_out)
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        if (requestCode == REQUEST_CODE_DECRYPT) {
            if (resultCode == Activity.RESULT_OK) {
                //try to decrypt again
                val nodeOrigText = intent.getStringExtra(EXTRA_ENCRYPTED_TEXT)
                try {
                    val dr =
                        CryptoHandlerFacade.getInstance(this).decryptWithLock(nodeOrigText, data)
                    CoreContract.instance!!.putInEncryptionCache(nodeOrigText, dr!!)
                    update(dr)
                } catch (e: UserInteractionRequiredException) {
                    try {
                        startIntentSenderForResult(
                            e.pendingIntent.intentSender,
                            REQUEST_CODE_DECRYPT,
                            null,
                            0,
                            0,
                            0
                        )
                    } catch (e1: IntentSender.SendIntentException) {
                        // and now??
                    }
                }
            } else {
                Ln.w("user cancelled pendingintent activity")
            }
        } else if (requestCode == REQUEST_CODE_DOWNLOAD_MISSING_KEYS) {
            if (resultCode == Activity.RESULT_OK) {
                update(data)
            } else {
                Ln.w("user cancelled pendingintent activity")
            }
        } else
            if (requestCode == REQUEST_CODE_SHOW_SIGNATURE_KEY) {
                //nothing to be done
            }
    }

    companion object {
        private const val EXTRA_ENCRYPTED_TEXT = "enc_text"
        private const val EXTRA_PACKAGENAME = "packagename"

        const val REQUEST_CODE_DECRYPT = 5001
        const val REQUEST_CODE_DOWNLOAD_MISSING_KEYS = 5002
        const val REQUEST_CODE_SHOW_SIGNATURE_KEY = 5003

        fun show(ctx: Context, packagename: String, encryptedText: String, source: View?) {
            val i = Intent()
            i.setClass(ctx, EncryptionInfoActivity::class.java)
            i.putExtra(EXTRA_ENCRYPTED_TEXT, encryptedText)
            i.putExtra(EXTRA_PACKAGENAME, packagename)

            i.flags = (Intent.FLAG_ACTIVITY_CLEAR_TASK
                    or Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS)

            val opts = source?.let {  ActivityOptions.makeScaleUpAnimation(it, 0, 0, 0, 0) }
            if (opts != null) {
                ctx.startActivity(i, opts.toBundle())
            } else {
                ctx.startActivity(i)
            }

        }
    }

}
