Thank you for your interest in contributing to Nori or Norilib. Before you get
started, we ask you to read these guidelines to make sure that your
contribution is consistent with the code style and quality used throughout the
project.

Before you start contributing to Nori or Norilib, you also need to sign the
[Contributor License Agreement](https://www.clahub.com/agreements/tjg1/nori).

If you have any questions, you're welcome to join other developers on our IRC
channel, `#nori` on `irc.freenode.net`.

Code Style
----------

Please reformat your code using the Android Studio default settings,
except for:

* Using 2 spaces for indentation.
* Using 4 spaces for continuation indents.
* Using single-line JavaDoc comments for class/instance fields (variables).
* All methods and fields must have a JavaDoc comment (including private ones),
  unless they're overriding a member of the base class/interface.
* Empty method bodies must contain a comment to indicate that they were
  left empty intentionally.

GitHub Contribution Style
-------------------------

* Commit subjects (first line of the commit message) must start with an
  upper-case character, be no longer than 72 characters long and use the
  imperative tense. (`Fix` not `Fixes`, `Fixed` or `Fixing`)
* Pull request must include steps to verify or test the changes that were made.
  Changes to the UI or graphical assets must include screenshots.
* All issues must have at least one label set.
  Bug reports must include reproduction steps.

Contributor License Agreement
-----------------------------

The following terms are used throughout this agreement:

* **You** - the person or legal entity including its affiliates asked to accept
  accept this agreement. An affiliate is any entity that controls or is
  controlled by the legal entity, or is under common control with it.
* **Project** - is an umbrella term that refers to any and all GitHub open
  source repositories that are a part of Nori and Norilib.
* **Contribution** - any type of work that is submitted to a Project, including
  any modifications or additions to existing work.
* **Submitted** - conveyed to a Project via a pull request, commit, issue, or
  any form of electronic, written, or verbal communication with Projects’
  maintainers, contributors and users.

### 1. Grant of Copyright License. ###

Subject to the terms and conditions of this agreement, You grant Projects’
maintainers, contributors and users a perpetual, worldwide, non-exclusive,
no-charge, royalty-free, irrevocable copyright license to reproduce, prepare
derivative works of, publicly display, publicly perform, sublicense, and
distribute Your contributions and such derivative works. Except for this
license, You reserve all rights, title, and interest in your contributions.

### 2. Grant of Patent License. ###

Subject to the terms and conditions of this agreement, You grant to the
Projects’ maintainers, contributors, users a perpetual, worldwide,
non-exclusive, no-charge, royalty-free, irrevocable (except as stated in this
section) patent license to make, have made, use, offer to sell, sell, import,
and otherwise transfer your contributions, where such license applies only to
those patent claims licensable by you that are necessarily infringed by your
contribution or by combination of your contribution with the project to which
this contribution was submitted.

If any entity institutes patent litigation - including cross-claim or
counterclaim in a lawsuit - against You alleging that your contribution or any
project it was submitted to constitutes or is responsible for direct or
contributory patent infringement, then any patent licenses granted to that
entity under this agreement shall terminate as of the date such litigation is
filed.

### 3. Source of Contribution. ###

Your contribution is either your original creation, based upon previous work
that, to the best of your knowledge, is covered under an appropriate open source
license and you have the right under that license to submit that work with
modifications, whether created in whole or in part by you, or you have clearly
identified the source of the contribution and any license or other restriction
(like related patents, trademarks, and license agreements) of which you are
personally aware.

