/*
 * This file is part of nori.
 * Copyright (c) 2014-2016 Tomasz Jan Góralczyk <tomg@fastmail.uk>
 * License: GNU GPLv2
 */

package io.github.tjg1.nori;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.preference.EditTextPreference;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceScreen;
import android.support.design.widget.AppBarLayout;
import android.support.v7.widget.AppCompatCheckBox;
import android.support.v7.widget.AppCompatCheckedTextView;
import android.support.v7.widget.AppCompatEditText;
import android.support.v7.widget.AppCompatRadioButton;
import android.support.v7.widget.AppCompatSpinner;
import android.support.v7.widget.Toolbar;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ListView;

import io.github.tjg1.nori.service.ClearSearchHistoryService;

/** Main settings activity managing all the core preferences for the app, launched from {@link io.github.tjg1.nori.SearchActivity}. */
@SuppressWarnings("deprecation")
// The non-fragment Preferences API is deprecated, but there is no alternative in the support library for API<11 support.
public class SettingsActivity extends PreferenceActivity
    implements SharedPreferences.OnSharedPreferenceChangeListener {

  //region Activity lifecycle
  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);


    AppBarLayout bar;

    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
      LinearLayout root = (LinearLayout) findViewById(android.R.id.list).getParent().getParent().getParent();
      bar = (AppBarLayout) LayoutInflater.from(this).inflate(R.layout.toolbar_settings, root, false);
      root.addView(bar, 0);
    } else {
      ViewGroup root = (ViewGroup) findViewById(android.R.id.content);
      ListView content = (ListView) root.getChildAt(0);
      root.removeAllViews();
      bar = (AppBarLayout) LayoutInflater.from(this).inflate(R.layout.toolbar_settings, root, false);

      int height;
      TypedValue tv = new TypedValue();
      if (getTheme().resolveAttribute(R.attr.actionBarSize, tv, true)) {
        height = TypedValue.complexToDimensionPixelSize(tv.data, getResources().getDisplayMetrics());
      } else {
        height = bar.getHeight();
      }

      content.setPadding(0, height, 0, 0);

      root.addView(content);
      root.addView(bar);
    }

    Toolbar Tbar = (Toolbar) bar.getChildAt(0);

    Tbar.setNavigationOnClickListener(new View.OnClickListener() {
      public void onClick(View v) {
        finish();
      }
    });

    addPreferencesFromResource(R.xml.preferences);
  }

  @Override
  public View onCreateView(String name, Context context, AttributeSet attrs) {
    // Allow super to try and create a view first
    final View result = super.onCreateView(name, context, attrs);
    if (result != null) {
      return result;
    }

    if (Build.VERSION.SDK_INT < Build.VERSION_CODES.LOLLIPOP) {
      // If we're running pre-L, we need to 'inject' our tint aware Views in place of the
      // standard framework versions
      switch (name) {
        case "EditText":
          return new AppCompatEditText(this, attrs);
        case "Spinner":
          return new AppCompatSpinner(this, attrs);
        case "CheckBox":
          return new AppCompatCheckBox(this, attrs);
        case "RadioButton":
          return new AppCompatRadioButton(this, attrs);
        case "CheckedTextView":
          return new AppCompatCheckedTextView(this, attrs);
      }
    }

    return null;
  }

  @Override
  protected void onResume() {
    super.onResume();

    // Register listener used to update the summary of ListPreferences with their current value.
    SharedPreferences sharedPreferences = getPreferenceScreen().getSharedPreferences();
    sharedPreferences.registerOnSharedPreferenceChangeListener(this);

    // Iterate through shared preferences to update preference summaries when the activity is started.
    for (String key : sharedPreferences.getAll().keySet()) {
      onSharedPreferenceChanged(sharedPreferences, key);
    }
  }

  @Override
  public boolean onOptionsItemSelected(MenuItem item) {
    switch (item.getItemId()) {
      case android.R.id.home:
        // Make the action bar "up" button behave the same way as the physical "back" button.
        onBackPressed();
        return true;
      default:
        return super.onOptionsItemSelected(item);
    }
  }

  @Override
  protected void onPause() {
    super.onPause();

    // Unregister SharedPreferenceChangeListener.
    getPreferenceScreen().getSharedPreferences().unregisterOnSharedPreferenceChangeListener(this);
  }
  //endregion

  //region PreferenceActivity methods
  @Override
  public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
    // Override default action for the clear search history preference item.
    if (preference.getKey() != null && preference.getKey().equals("preference_clearSearchHistory")) {
      // Start ClearSearchHistoryService.
      Intent intent = new Intent(this, ClearSearchHistoryService.class);
      startService(intent);
      return true;
    } else {
      return super.onPreferenceTreeClick(preferenceScreen, preference);
    }
  }
  //endregion

  //region SharedPreferences.OnSharedPreferenceChangeListener (show current values as summaries)
  @Override
  public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
    Preference preference = findPreference(key);

    // Set the summary for each ListPreference and EditTextPreference to its current value.
    if (preference instanceof ListPreference) {
      ListPreference listPreference = (ListPreference) preference;
      listPreference.setSummary(listPreference.getEntry());
    } else if (preference instanceof EditTextPreference) {
      EditTextPreference editTextPreference = (EditTextPreference) preference;
      editTextPreference.setSummary(editTextPreference.getText());
    }
  }
  //endregion
}
