# Fabularium

This is the source code for the Fabularium app at https://play.google.com/store/apps/details?id=com.luxlunae.fabularium.

## About

Create and play interactive fiction on your Android phone or tablet. Also known as text adventures, interactive books, playable novels, z-machine, glulx, tads, terps. Fun for adults and also a great way to encourage children to read and develop their imaginations.

Fabularium can play all of the major formats: Adrift (including version 5), AdvSys, the Adventure Game Toolkit (AGT), Alan (2 and 3), Glulx, Hugo, Level 9, Magnetic Scrolls, Scott Adams Adventures (Scottfree), Tads (2 and 3) and Zcode (Infocom). It also includes a simple integrated development environment (IDE) for creating your own Glulx, Tads 3 and Zcode games.

Fabularium supports Unicode games, so if you would prefer to play in a language other than English, no problems! Either define your own keyboard via the keyboards.ini file (see examples in that file) or disable the built-in keyboard via the settings, to use your system keyboard. Keyboards defined via keyboards.ini can have multiple layouts and each key can be programmed to generate one Unicode character, a complete command, or even multiple commands, that are fed to the interpreter one by one. As with anything else in fab.ini, you can set the different keyboards you've defined in keyboards.ini to automatically load with different game and terp combinations.

Fabularium takes accessibility seriously. Much of the app is now TalkBack enabled and the built-in keyboard supports "explore by touch" and "lift to type" technology. Accessibility features will continue to improve over the coming releases. If you are blind or vision-impaired and would like to help me with this (e.g. testing and feature suggestions), let me know.

We care about typography! While the default settings should work for most games, Fabularium is also highly customisable. Make the margins as narrow or as wide as you want. Don't like the default fonts and colours? Change them. Adjust line spacing. Fiddle with other typographical features. Optimise that game for your device's screen. For maximum screen space, try using a hardware keyboard.

Fabularium is and always will be completely free, with no ads, and open source. It does not come bundled with any games; you will need to obtain these separately. There are many games freely available at www.ifdb.tads.org and www.ifarchive.org. You can download these games anywhere to your internal storage/SD card and then add them to your library from within the app. The app is also able to extract files from ZIP archives.

Inspired by the great Gargoyle interpreter by Tor Andersson, Fabularium implements Andrew Plotkin's Glk 0.7.5 spec in Android and can therefore support any glk-enabled interpreter. More interpreters may be added in the future.

For further information see the in-app help.

## Compiling

*Using Android Studio:*

1. Clone the repository to your local machine (git clone https://github.com/tccowper/fabularium.git).
2. Open a recent version of Android Studio (e.g. 3.3.1). 
3. Choose "Import project (Gradle, Eclipse ADT, etc.)" and, when prompted, select the root folder of the cloned repository. 
4. The project should open in Android Studio - if prompted, choose to recreate any missing gradle wrapper files, etc. 
5. Build it within Android Studio as you would any other app (Build=>Make project, Ctrl+F9, etc.).

## Contact details

Questions, comments, feedback and suggestions for future features always welcome, please contact me at tcowperapps@gmail.com.
