//=========================================================================
//
//  Part of PEG parser generator Mouse.
//
//  Copyright (C) 2009 by Roman R. Redziejowski (www.romanredz.se).
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//-------------------------------------------------------------------------
//
//  Change log
//    090701 License changed by the author to Apache v.2.
//    090810 Renamed from 'SourceString' and package name changed.
//   Version 1.2
//    091105 Modified where() to insert three dots.
//
//=========================================================================

package units;


public class SourceString implements Source
{
  final String text;

  public SourceString(final String s)
    { text = s; }

  public boolean created()
    { return true; }

  public int end()
    { return text.length(); }

  public char at(int p)
    { return text.charAt(p); }

  public String at(int p, int q)
    { return text.substring(p,q); }

  public String where(int p)
    {
      if (p>15)
        return "After '... " + text.substring(p-15,p) + "'";
      else if (p>0)
        return "After '" + text.substring(0,p) + "'";
      else
        return "At start";
    }
}
