# 10,000 sentences

10,000 sentences is an Android app to help you learn new words in a foreign language.

<a href='https://play.google.com/store/apps/details?id=info.puzz.a10000sentences&pcampaignid=MKT-Other-global-all-co-prtnr-py-PartBadge-Mar2515-1'><img alt='Get it on Google Play' src='https://play.google.com/intl/en_us/badges/images/generic/en_badge_web_generic.png' width="200"/></a>

## How it works

The idea is to go through 10,000 sentences in a language you learn. First you will see a sentence in a language you known and then you must guess the words of the same sentence in your target language. By exposing you to unknown words in a real context (a sentence) you will slowly (but steadily) increase your vocabulary size.

At the moment the app has 12 languages, but more can be added easily. The sentences are ordered by complexity (more common words and shorter sentences first). The sentences collections are extracted from the [Tatoeba](https://tatoeba.org) collection (licensed under CC-BY 2.0).

Text-to-speech is available for some languages (depending on your Android phone and version).

All words can be opened directly in Google Translate or AnkiDroid (or any other flashcard or spaced repetition app).

Each sentence can be under one of the following statuses:

- _TODO_ -- meaning that you haven't exercised with them
- _DONE_ -- meaning that you guessed all words correctly
- _REPEAT_ -- meaning that you tried, but failed, to guess words correctly. The sentence will be retried (shown in quizzes) until you succeed in guessing it.
- _IGNORE_ -- meaning that you decided you don't want this sentence to show in your quizzes

The app will allow only a certain number of _REPEAT_ sentences. If you reach that number, no new sentences will be shown to you. Only when you fix _REPEAT_ sentences (i.e. succeed in guessing all the words), new ones will be available for you.

# Help, FAQ

## Can I learn a language by using this app?

This app is a helper tool to help you increase your vocabulary by exposing you to thousands of sentences. In addition to using it, you should also pursue other (more traditional) ways of learning a language: speaking to native speakers, learning grammar, etc.

## Workflow

There are many ways to use this application. If you are a serious learner, you will probably develop your own daily routine.

This application is best used in combination with a translator app (or a traditional dictionary) and a memory flashcard application (like AnkiDroid).

A simple workflow idea:

 * Train sentence by sentence
 * If unsure about a word meaning, use translation
 * When you encounter a new (unknown) word:
    * check if this word should be part of an annotation you previously created or
    * create a new annotation

## Translate words

You must have Google translate installed for this option to work.

If you use another translation app, you can open with the "Open with..." option in the menus.

## Annotations

The application allows you to write **annotations** on words. More than one words can be annotated with the same annotation.

Annotations are best used to create your own dictionary as you proceed learning new sentences.
If you use annotations like a dictionary, make sure that you write them in grammatically neutral way.
For example, if you learn Italian, you will need to put "camminare" (to walk), "cammino" (I walk), "camminero" (I will walk) under one annotation (for example "walk").

This application is not able to discern if "camminero" (I will walk) and "camminavo" (I was walking) are one and the same word.
It is up to you to figure out that it must be **one** annotation, but this journey of "figuring out" words is part of language learning.

## Text to speech (TTS)

Most Android phones have text-to-speech (TTS) available for some languages. Some languages have very poor TTS voice quality. Check your phone settings to see if there is an option to download a better quality TTS. Some languages have also additional TTS applications available on the Google Play store.

# TODO

* Skip sentences for advanced users who feel the first sentences are too easy.
* Stats with graphs, goals, ...
* Add more languages
* better way/place to show annotations in quizzes
* Other quiz types:
    * listening comprehension: listen to voice then guess words (without seeing the original sentence, it will be visible only at the end)

Maybe:
* share progress with other users, global rating lists for different languages

# Screenshots

![001](http://tkrajina.github.io/10000sentences/images/001.png)
![002](http://tkrajina.github.io/10000sentences/images/002.png)
![003](http://tkrajina.github.io/10000sentences/images/003.png)
![004](http://tkrajina.github.io/10000sentences/images/004.png)
![005](http://tkrajina.github.io/10000sentences/images/005.png)
![006](http://tkrajina.github.io/10000sentences/images/006.png)
![007](http://tkrajina.github.io/10000sentences/images/007.png)
![008](http://tkrajina.github.io/10000sentences/images/008.png)

# License

10,000 sentences is licensed under the [Apache License, Version 2.0](http://www.apache.org/licenses/LICENSE-2.0)
