package grmpl.mk.stepandheightcounter;

import android.Manifest;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import androidx.preference.PreferenceManager;
import androidx.core.app.ActivityCompat;


// checking write access to SD-Card
class CheckSDCard {
    // variable to hold context
    private Context mContext;

    CheckSDCard(Context context) {
        mContext = context;
    }

    boolean checkWriteSDCard() {
        boolean mExternalStorageWriteable = false;
        String state = Environment.getExternalStorageState();

        if ( (ActivityCompat.checkSelfPermission(mContext,
                Manifest.permission.WRITE_EXTERNAL_STORAGE) == PackageManager.PERMISSION_GRANTED)
              || (Build.VERSION.SDK_INT >=  Build.VERSION_CODES.Q) )
            // if mounted rw this is true, else this will be false
            mExternalStorageWriteable = Environment.MEDIA_MOUNTED.equals(state);
        else {
            // doesn't work if called from service!
            // ActivityCompat.requestPermissions((Activity) mContext, new String[]{Manifest.permission.WRITE_EXTERNAL_STORAGE},1);
            // so, we use sharedpref
            SharedPreferences.Editor editpref = PreferenceManager.getDefaultSharedPreferences(mContext).edit();
            editpref.putBoolean("mReqSDPermission",true);
            editpref.apply();
        }
        return mExternalStorageWriteable;
    }
}
