/*
 * campfire, formerly known as bandcampDirect
 * Copyright (C) 2020 Fynn Godau
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Not affiliated with bandcamp, Incorporated.
 */

package godau.fynn.bandcampdirect.adapter;

import android.content.Intent;
import android.net.Uri;
import godau.fynn.bandcampdirect.activity.AlbumActivity;
import godau.fynn.bandcampdirect.activity.ArtistActivity;
import godau.fynn.bandcampdirect.activity.DiscoverActivity;
import godau.fynn.bandcampdirect.model.RowViewDisplayable;
import godau.fynn.bandcampdirect.view.RowView;

import java.util.List;

public class SearchResultAdapter extends RowAdapter<RowViewDisplayable> {

    public SearchResultAdapter(List<RowViewDisplayable> list) {
        super(list);
    }

    @Override
    public void onBindViewHolder(RowView rowView, RowViewDisplayable rowViewDisplayable, int position) {

        rowView.bind(rowViewDisplayable.getClass().getSimpleName() + ": " + rowViewDisplayable.getTitle(), false, rowViewDisplayable.getAction());

        switch (rowViewDisplayable.getAction()) {
            case OPEN:

                rowView.setOnButtonClickListener(v -> {
                    Intent intent = new Intent(context, AlbumActivity.class);
                    intent.setData(Uri.parse(rowViewDisplayable.getUrl()));

                    context.startActivity(intent);

                });
                break;
            case ARTIST_OPEN:

                rowView.setOnButtonClickListener(v -> {
                    Intent intent = new Intent(context, ArtistActivity.class);
                    intent.putExtra(ArtistActivity.ARTIST_ID, Long.parseLong(rowViewDisplayable.getUrl()));
                    context.startActivity(intent);
                });

                break;
            case DISCOVER:

                rowView.setOnButtonClickListener(v -> {
                    Intent intent = new Intent(context, DiscoverActivity.class);
                    intent.putExtra(DiscoverActivity.EXTRA_URL, rowViewDisplayable.getUrl());
                    context.startActivity(intent);
                });

                break;
        }

        loadImage(rowView, rowViewDisplayable, rowViewDisplayable.getCover());

    }
}
