/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.endless;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import com.commonsware.cwac.adapter.AdapterWrapper;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class EndlessAdapter
extends AdapterWrapper {
    private View pendingView = null;
    private AtomicBoolean keepOnAppending = new AtomicBoolean(true);
    private Context context;
    private int pendingResource = -1;
    private boolean isSerialized = false;
    private boolean runInBackground = true;

    protected abstract boolean cacheInBackground() throws Exception;

    protected abstract void appendCachedData();

    public EndlessAdapter(ListAdapter wrapped) {
        super(wrapped);
    }

    public EndlessAdapter(ListAdapter wrapped, boolean keepOnAppending) {
        super(wrapped);
        this.setKeepOnAppending(keepOnAppending);
    }

    public EndlessAdapter(Context context, ListAdapter wrapped, int pendingResource) {
        super(wrapped);
        this.context = context;
        this.pendingResource = pendingResource;
    }

    public EndlessAdapter(Context context, ListAdapter wrapped, int pendingResource, boolean keepOnAppending) {
        super(wrapped);
        this.context = context;
        this.pendingResource = pendingResource;
        this.setKeepOnAppending(keepOnAppending);
    }

    public boolean isSerialized() {
        return this.isSerialized;
    }

    public void setSerialized(boolean isSerialized) {
        this.isSerialized = isSerialized;
    }

    public void stopAppending() {
        this.setKeepOnAppending(false);
    }

    public void restartAppending() {
        this.setKeepOnAppending(true);
    }

    public void setRunInBackground(boolean runInBackground) {
        this.runInBackground = runInBackground;
    }

    public void onDataReady() {
        this.pendingView = null;
        this.notifyDataSetChanged();
    }

    public int getCount() {
        if (this.keepOnAppending.get()) {
            return super.getCount() + 1;
        }
        return super.getCount();
    }

    public int getItemViewType(int position) {
        if (position == this.getWrappedAdapter().getCount()) {
            return -1;
        }
        return super.getItemViewType(position);
    }

    public int getViewTypeCount() {
        return super.getViewTypeCount() + 1;
    }

    public Object getItem(int position) {
        if (position >= super.getCount()) {
            return null;
        }
        return super.getItem(position);
    }

    public boolean areAllItemsEnabled() {
        return false;
    }

    public boolean isEnabled(int position) {
        if (position >= super.getCount()) {
            return false;
        }
        return super.isEnabled(position);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (position == super.getCount() && this.keepOnAppending.get()) {
            if (this.pendingView == null) {
                this.pendingView = this.getPendingView(parent);
                if (this.runInBackground) {
                    this.executeAsyncTask(this.buildTask(), new Void[0]);
                } else {
                    try {
                        this.setKeepOnAppending(this.cacheInBackground());
                    }
                    catch (Exception e) {
                        this.setKeepOnAppending(this.onException(this.pendingView, e));
                    }
                }
            }
            return this.pendingView;
        }
        return super.getView(position, convertView, parent);
    }

    protected boolean onException(View pendingView, Exception e) {
        Log.e((String)"EndlessAdapter", (String)"Exception in cacheInBackground()", (Throwable)e);
        return false;
    }

    protected AppendTask buildTask() {
        return new AppendTask(this);
    }

    @TargetApi(value=11)
    private <T> void executeAsyncTask(AsyncTask<T, ?, ?> task, T ... params) {
        if (!this.isSerialized && Build.VERSION.SDK_INT >= 11) {
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])params);
        } else {
            task.execute((Object[])params);
        }
    }

    private void setKeepOnAppending(boolean newValue) {
        boolean same = newValue == this.keepOnAppending.get();
        this.keepOnAppending.set(newValue);
        if (!same) {
            this.notifyDataSetChanged();
        }
    }

    protected View getPendingView(ViewGroup parent) {
        if (this.context != null) {
            LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
            return inflater.inflate(this.pendingResource, parent, false);
        }
        throw new RuntimeException("You must either override getPendingView() or supply a pending View resource via the constructor");
    }

    protected Context getContext() {
        return this.context;
    }

    protected static class AppendTask
    extends AsyncTask<Void, Void, Exception> {
        EndlessAdapter adapter = null;
        boolean tempKeep;

        protected AppendTask(EndlessAdapter adapter) {
            this.adapter = adapter;
        }

        protected Exception doInBackground(Void ... params) {
            Exception result = null;
            try {
                this.tempKeep = this.adapter.cacheInBackground();
            }
            catch (Exception e) {
                result = e;
            }
            return result;
        }

        protected void onPostExecute(Exception e) {
            this.adapter.setKeepOnAppending(this.tempKeep);
            if (e == null) {
                this.adapter.appendCachedData();
            } else {
                this.adapter.setKeepOnAppending(this.adapter.onException(this.adapter.pendingView, e));
            }
            this.adapter.onDataReady();
        }
    }
}

