/**
 * Scrabble for French
 * This code has been mainly written by Christophe Cerisara, but reuses pieces of codes from Eidogo.
 * Copyright (c) 2015, Christophe Cerisara <cerisara@gmail.com>
 * Copyright (c) 2007, Justin Kramer <jkkramer@gmail.com>
 * Code licensed under AGPLv3:
 * http://www.fsf.org/licensing/licenses/agpl-3.0.html
**/

(function() {

scrab.Player = function() {
    this.init.apply(this, arguments);
}

scrab.Player.prototype = {
     init: function(cfg) {
	this.delCase = 0;

        cfg = cfg || {};

        // play, add_b, add_w, region, tr, sq, cr, label, number, score(?)
        this.mode = cfg.mode ? cfg.mode : "play";

        // for references to all our DOM objects -- see constructDom()
        this.dom = {};
        if (typeof cfg.container == "string") {
            this.dom.container = scrab.util.byId(cfg.container);
	} else {
            this.dom.container = cfg.container;
	}

        if (!this.dom.container) {
            alert(t['dom error']);
            return;
        }

        // unique id, so we can have more than one player on a page
        this.uniq = (new Date()).getTime();

        this.renderer = "html";

	// crop settings
        this.cropParams = null;
        this.shrinkToFit = cfg.shrinkToFit;
        if (this.shrinkToFit || cfg.cropWidth || cfg.cropHeight) {
            this.cropParams = {};
            this.cropParams.width = cfg.cropWidth;
            this.cropParams.height = cfg.cropHeight;
            this.cropParams.left = cfg.cropLeft;
            this.cropParams.top = cfg.cropTop;
            this.cropParams.padding = cfg.cropPadding || 1;
        }

	// set up the elements we'll use
        this.constructDom();
	this.createBoard();
    },

    createBoard: function() {
	try {
            this.dom.boardContainer.innerHTML = "";
            var rendererProto = scrab.BoardRendererHtml;
            var renderer = new rendererProto(this.dom.boardContainer, this, this.cropParams);
            this.board = new scrab.Board(renderer);
        } catch (e) {
            if (e == "No DOM container") {
                this.croak(t['error board']);
                return;
            }
        }
    },

    constructDom: function() {

        this.dom.player = document.createElement('div');
        this.dom.player.className = "scrab-player" +
            (this.theme ? " theme-" + this.theme : "");
        this.dom.player.id = "player-" + this.uniq;
        this.dom.container.innerHTML = "";
        scrab.util.show(this.dom.container);
        this.dom.container.appendChild(this.dom.player);

        var domHtml = "\
            <div id='board-container' class='board-container'></div>\
        ";

        // unique ids for each element so we can have multiple Player
        // instances on a page
        domHtml = domHtml.replace(/ id='([^']+)'/g, " id='$1-" + this.uniq + "'");
        this.dom.player.innerHTML = domHtml;

	// grab all the dom elements for later use
        var re = / id='([^']+)-\d+'/g;
        var match;
        var id;
        var jsName;
        while (match = re.exec(domHtml)) {
            id = match[0].replace(/'/g, "").replace(/ id=/, "");
            jsName = "";
            // camel-case the id
            match[1].split("-").forEach(function(word, i) {
                word = i ? word.charAt(0).toUpperCase() + word.substring(1) : word;
                jsName += word
            });
            this.dom[jsName] = scrab.util.byId(id);
        }
    },

    detShowLettre: function(s) {
	var xx = parseInt(s);
	var mx = Math.floor(xx/10000);
	var re = xx % 10000;
	var my = Math.floor(re/100);
	var ll = re % 100;
	var ca = "motX3";
	if (ll==0) {
		ca = "A";
	} else if (ll==1) {
		ca = "B";
	} else if (ll==2) {
		ca = "C";
	} else if (ll==3) {
		ca = "D";
	} else if (ll==4) {
		ca = "E";
	} else if (ll==5) {
		ca = "F";
	} else if (ll==6) {
		ca = "G";
	} else if (ll==7) {
		ca = "H";
	} else if (ll==8) {
		ca = "I";
	} else if (ll==9) {
		ca = "J";
	} else if (ll==10) {
		ca = "K";
	} else if (ll==11) {
		ca = "L";
	} else if (ll==12) {
		ca = "M";
	} else if (ll==13) {
		ca = "N";
	} else if (ll==14) {
		ca = "O";
	} else if (ll==15) {
		ca = "P";
	} else if (ll==16) {
		ca = "Q";
	} else if (ll==17) {
		ca = "R";
	} else if (ll==18) {
		ca = "S";
	} else if (ll==19) {
		ca = "T";
	} else if (ll==20) {
		ca = "U";
	} else if (ll==21) {
		ca = "V";
	} else if (ll==22) {
		ca = "W";
	} else if (ll==23) {
		ca = "X";
	} else if (ll==24) {
		ca = "Y";
	} else if (ll==25) {
		ca = "Z";
	} else if (ll==50) {
		ca = "empty";
	}
	scrab.boardRenderer.renderCase({x:mx,y:my},ca);
    },

    detDelLettre: function(s) {
	var xx = parseInt(s);
	var mx = Math.floor(xx/10000);
	var re = xx % 10000;
	var my = Math.floor(re/100);
	var ll = re % 100;
	var ca = "motX3";
	if (ll==0) {
		ca = "A";
	} else if (ll==1) {
		ca = "B";
	} else if (ll==2) {
		ca = "C";
	} else if (ll==3) {
		ca = "D";
	} else if (ll==4) {
		ca = "E";
	} else if (ll==5) {
		ca = "F";
	} else if (ll==6) {
		ca = "G";
	} else if (ll==7) {
		ca = "H";
	} else if (ll==8) {
		ca = "I";
	} else if (ll==9) {
		ca = "J";
	} else if (ll==10) {
		ca = "K";
	} else if (ll==11) {
		ca = "L";
	} else if (ll==12) {
		ca = "M";
	} else if (ll==13) {
		ca = "N";
	} else if (ll==14) {
		ca = "O";
	} else if (ll==15) {
		ca = "P";
	} else if (ll==16) {
		ca = "Q";
	} else if (ll==17) {
		ca = "R";
	} else if (ll==18) {
		ca = "S";
	} else if (ll==19) {
		ca = "T";
	} else if (ll==20) {
		ca = "U";
	} else if (ll==21) {
		ca = "V";
	} else if (ll==22) {
		ca = "W";
	} else if (ll==23) {
		ca = "X";
	} else if (ll==24) {
		ca = "Y";
	} else if (ll==25) {
		ca = "Z";
	} else if (ll==50) {
		ca = "empty";
	}
	scrab.boardRenderer.delCase({x:mx,y:my},ca);
    },

    handleBoardMouseDown: function(mx, my, e) {
        if (this.domLoading) return;

	if (mx<0||my<0||mx>14||my>14) {
//		this.delCase = 1-this.delCase;
		return;
	}
	if (this.delCase == 1) {
	    this.board.renderer.delCase({x: mx, y: my},"A");
	} else {
	    this.board.renderer.renderCase({x: mx, y: my},"A");
	}

//        if (!this.boundsCheck(x, y, [0, this.board.boardSize-1])) return;
/*
        this.mouseDown = true;
        this.mouseDownX = x;
        this.mouseDownY = y;
        // begin region selection
        if (this.mode == "region" && x >= 0 && y >= 0 && !this.regionBegun) {
            this.regionTop = y;
            this.regionLeft = x;
            this.regionBegun = true;
        }
*/
    },

};

})();

