/*
 * Copyright 2019 Thibault Seisel
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package fr.nihilus.music.library.artists

import androidx.lifecycle.ViewModel
import dagger.Binds
import dagger.Module
import dagger.android.ContributesAndroidInjector
import dagger.multibindings.IntoMap
import fr.nihilus.music.core.ui.viewmodel.ViewModelKey
import fr.nihilus.music.library.artists.detail.ArtistDetailFragment
import fr.nihilus.music.library.artists.detail.ArtistDetailViewModel

@Module
internal abstract class ArtistsModule {

    @ContributesAndroidInjector
    abstract fun artistListFragment(): ArtistsFragment

    @ContributesAndroidInjector
    abstract fun artistDetailFragment(): ArtistDetailFragment

    @Binds @IntoMap
    @ViewModelKey(ArtistDetailViewModel::class)
    abstract fun bindsArtistDetailViewModel(viewModel: ArtistDetailViewModel): ViewModel
}