package fr.magistry.taigime;

import android.graphics.Typeface;
import android.os.Bundle;
import android.preference.CheckBoxPreference;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.Arrays;


public class OptionsActivity extends Activity {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_options);
		SharedPreferences settings = getSharedPreferences("TAIGI_IME", 0);
	    LinearLayout container = (LinearLayout) this.getWindow().findViewById(R.id.LinearLayout1);
        final Spinner sp_input_mode = (Spinner) this.getWindow().findViewById(R.id.spinner_input_mode);
        final Spinner sp_output_mode = (Spinner) this.getWindow().findViewById(R.id.spinner_output_mode);
        final Spinner sp_keyboard = (Spinner) this.getWindow().findViewById(R.id.spinner_keyboard);
	    String[] dialects = getResources().getStringArray(R.array.dialect_list);
        Typeface tf = Typeface.createFromAsset(getAssets(),"fonts/NotoSerif-Regular-bopomofo.ttf");
        //Typeface tf = Typeface.createFromAsset(getAssets(),"fonts/NotoSansCJKsc-Regular.otf");
        Context ctxt = container.getContext();

	    for(String d: dialects){
			CheckBox cb = new CheckBox(ctxt);
			cb.setText(d);
			cb.setChecked(settings.getBoolean(d, false));
			cb.setOnCheckedChangeListener(build_listener_from_string(d));
			container.addView(cb);
	    }
        sp_input_mode.setSelection(settings.getInt("input_mode",0));
        sp_output_mode.setSelection(settings.getInt("output_mode",0));
        sp_keyboard.setSelection(settings.getInt("keyboard",0));



        MyArrayAdapter adapter = new MyArrayAdapter(this,R.layout.spinner_style);
        sp_output_mode.setPromptId(R.string.pref_romanisation_output);
        adapter.setDropDownViewResource(R.layout.romanisation_output);
        adapter.addAll(Arrays.asList(getResources().getStringArray(R.array.romanisations_output_list)));
        sp_output_mode.setAdapter(adapter);

        adapter = new MyArrayAdapter(this,R.layout.spinner_style);
        sp_input_mode.setPromptId(R.string.pref_romanisation_input);
        adapter.setDropDownViewResource(R.layout.romanisation_output);
        adapter.addAll(Arrays.asList(getResources().getStringArray(R.array.romanisations_list)));
        sp_input_mode.setAdapter(adapter);

        adapter = new MyArrayAdapter(this,R.layout.spinner_style);
        sp_input_mode.setPromptId(R.string.pref_keyboard);
        adapter.setDropDownViewResource(R.layout.romanisation_output);
        adapter.addAll(Arrays.asList(getResources().getStringArray(R.array.keyboards_list)));
        sp_keyboard.setAdapter(adapter);




        sp_input_mode.setOnItemSelectedListener(new OnItemSelectedListener() {
            public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
                getSharedPreferences("TAIGI_IME", 0).edit().putInt("input_mode", i).commit();
            }

            @Override
            public void onNothingSelected(AdapterView<?> arg0) {
                // TODO Auto-generated method stub
            }
        });

        sp_output_mode.setOnItemSelectedListener(new OnItemSelectedListener() {

            public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
                getSharedPreferences("TAIGI_IME", 0).edit().putInt("output_mode", i).commit();
            }
            @Override
            public void onNothingSelected(AdapterView<?> arg0) {
                // TODO Auto-generated method stub
            }
        });

        sp_keyboard.setOnItemSelectedListener(new OnItemSelectedListener() {

            public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
                getSharedPreferences("TAIGI_IME", 0).edit().putInt("keyboard", i).commit();
            }
            @Override
            public void onNothingSelected(AdapterView<?> arg0) {
                // TODO Auto-generated method stub
            }
        });



	}

	private OnCheckedChangeListener build_listener_from_string(final String s){
		return new OnCheckedChangeListener() {
			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
				getSharedPreferences("TAIGI_IME",0).edit().putBoolean(s, isChecked).commit();
			}
		};
	}
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.activity_options, menu);
		return true;
	}

    private class MyArrayAdapter extends ArrayAdapter {
        private Typeface tf;
        public MyArrayAdapter(Context context, int textViewResourceId) {
            super(context, textViewResourceId);
            tf = Typeface.createFromAsset(getAssets(),"fonts/NotoSerif-Regular-bopomofo.ttf");
            //tf = Typeface.createFromAsset(getAssets(),"fonts/NotoSansCJKsc-Regular.otf");
        }

        public TextView getView(int position, View convertView, ViewGroup parent) {
            TextView v = (TextView) super.getView(position, convertView, parent);
            v.setTypeface(tf);
            return v;
        }

        public TextView getDropDownView(int position, View convertView, ViewGroup parent) {
            TextView v = (TextView) super.getView(position, convertView, parent);
            v.setTypeface(tf);
            return v;
        }

    }

}
