//
// Copyright 2017, 2018 Filippo "Fil" Bergamo <fil.bergamo@riseup.net>
// 
// This file is part of RepWifiApp.
//
// RepWifiApp is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// RepWifiApp is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with RepWifiApp.  If not, see <http://www.gnu.org/licenses/>.
// 
// ********************************************************************

package fil.libre.repwifiapp.network;

import fil.libre.repwifiapp.helpers.Logger;
import fil.libre.repwifiapp.helpers.RootCommand;


public abstract class WpaSupplicant {

    public static final String INTERFACE_NAME = "wlan0";
    public static final String WORKDIR = "/data/misc/wifi";
    public static final String PID_FILE = WORKDIR + "/pidfile";
    public static final String SOCKET_DIR = WORKDIR + "/sockets";
    public static final String SOFTAP_FILE = WORKDIR + "/softap.conf";
    public static final String P2P_CONF = WORKDIR + "/p2p_supplicant.conf";
    public static final String WPA_CONF = WORKDIR + "/wpa_supplicant.conf";
    public static final String ENTROPY_FILE = WORKDIR + "/entropy.bin";
    public static final String OVERLAY_FILE = "/system/etc/wifi/wpa_supplicant_overlay.conf";

    protected static final String BASE_COMMNAD = "wpa_supplicant -B -dd -i" + INTERFACE_NAME + " -C" + SOCKET_DIR + " -P" + PID_FILE
                    + " -I" + OVERLAY_FILE + " -e" + ENTROPY_FILE;

    public static boolean start() {
       
        Logger.logDebug("startWpaSupplicant():");
        if (isRunning()){
            return true;
        }
        
        // needs root (for wpa_supplicant)
        if (RootCommand.executeRootCmd(BASE_COMMNAD)) {
            return true;
        } else {
            Logger.logDebug("Failed to start wpa");
            return false;
        }

    }

    public static boolean kill(){
        return RootCommand.executeRootCmd("killall -SIGINT wpa_supplicant");
    }
    
    public static boolean isRunning() {

        boolean retval = false;

        try {

            RootCommand su = new RootCommand("pidof wpa_supplicant");
            if (su.execute() == 0) {

                if (su.getOutput().trim().equals("")) {
                    retval = false;
                } else {
                    retval = true;
                }

            } else {
                retval = false;
            }

        } catch (Exception e) {
            Logger.logError("Exception during isWpaSupplicantRunning()", e);
            retval = false;
        }

        return retval;

    }

}
