//
// Copyright 2017, 2018 Filippo "Fil" Bergamo <fil.bergamo@riseup.net>
// 
// This file is part of RepWifiApp.
//
// RepWifiApp is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// RepWifiApp is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with RepWifiApp.  If not, see <http://www.gnu.org/licenses/>.
// 
// ********************************************************************
//
// This file is derivative work, inspired by the original class definition:
// "android.net.RouteInfo.java" as found in version 6.0 of the Android Operating System.
// Following is the original copyright notice:
/*
 * Copyright (C) 2011 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package fil.libre.repwifiapp.fwproxies;

import java.net.InetAddress;

public class RouteInfoProxy extends FrameworkProxy{

    @Override
    protected String getInnerClassName() {
        return "android.net.RouteInfo";
    }
    
    public RouteInfoProxy(InetAddress gateway, String ifaceName) {
        Class<?>[] sig = new Class<?>[]{getClassFromName("android.net.IpPrefix"),
                        InetAddress.class, String.class};
        createInnerObject(sig, null, gateway, ifaceName);
    }

    
    
}
