//
// Copyright 2017, 2018 Filippo "Fil" Bergamo <fil.bergamo@riseup.net>
// 
// This file is part of RepWifiApp.
//
// RepWifiApp is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// RepWifiApp is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with RepWifiApp.  If not, see <http://www.gnu.org/licenses/>.
// 
// ********************************************************************

package fil.libre.repwifiapp.activities;

import android.content.Intent;
import android.os.Bundle;
import android.view.Gravity;
import android.view.Menu;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.Spinner;
import android.widget.TextView;
import fil.libre.repwifiapp.ActivityLauncher;
import fil.libre.repwifiapp.R;
import fil.libre.repwifiapp.Utils;
import fil.libre.repwifiapp.network.AccessPointInfo;
import fil.libre.repwifiapp.network.NetworkManager;
import java.util.List;

public class VpnSettingsActivity extends VpnAndConnectionBoundActivity {

    private AccessPointInfo currentNetwork;
    private Spinner spinProfile;
    private TextView summaryView;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_vpn_settings);

        String title = getString(R.string.title_activity_vpn_settings);

        Intent intent = getIntent();
        if (!intent.hasExtra(ActivityLauncher.EXTRA_APINFO)) {
            this.setResult(RESULT_CANCELED);
            this.finish();
            return;
        }

        this.spinProfile = (Spinner) findViewById(R.id.spin_vpn_profile);
        this.summaryView = (TextView) findViewById(R.id.lbl_vpn_settings);
        String summary = getString(R.string.summary_vpn_settings).replace(PLACEHOLDER_APPNAME,
                        APP_COMMON_NAME);
        summaryView.setText(summary);
        
        this.currentNetwork = (AccessPointInfo) intent.getExtras().getParcelable(
                        ActivityLauncher.EXTRA_APINFO);
        
        this.currentNetwork = NetworkManager.getSavedNetwork(currentNetwork);
        
        if (this.currentNetwork != null) {
            title += " " + this.currentNetwork.getSsid();
            this.setTitle(title);
            toggleSettingsEnabled(true);
        }
    }

    @Override
    public void onStart() {
        
        super.onStart();
        if (!checkExternalApp() || currentNetwork == null) {
            toggleSettingsEnabled(false);
        } else {
            beginGetExistingVpnProfiles();
        }

    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        return true;
    }

    private boolean checkExternalApp() {

        if (!isExternalAppInstalled()) {
            String msg = getString(R.string.text_vpn_package_missing).replace(PLACEHOLDER_APPNAME,
                            APP_COMMON_NAME);
            Utils.showMessage(msg, this);
            toggleSettingsEnabled(false);
            return false;
        } else {
            return true;
        }

    }

    private void toggleSettingsEnabled(boolean enabled) {

        spinProfile.setEnabled(enabled);

        Button b = (Button) findViewById(R.id.btn_save_vpn_settings);
        b.setEnabled(enabled);

    }

    public void btnSaveClick(View v) {

        String vpnProf = (String) spinProfile.getSelectedItem();

        // save profile
        currentNetwork.setVpnProfileName(vpnProf);
        NetworkManager.save(currentNetwork);

        terminate();

    }

    public void btnBackClick(View v) {
        terminate();
    }

    private void terminate() {
        finish();
    }

    @Override
    protected void onVpnProfilesAvailable(List<String> profiles) {

        if (profiles.size() == 0) {
            String msg = getString(R.string.msg_vpn_no_profile).replace(PLACEHOLDER_APPNAME,
                            APP_COMMON_NAME);
            Utils.showMessage(msg, this);
            toggleSettingsEnabled(false);
            return;
        }
        Spinner spin = (Spinner) findViewById(R.id.spin_vpn_profile);

        ArrayAdapter<String> adapter = new ArrayAdapter<String>(this,
                        android.R.layout.simple_spinner_dropdown_item, profiles){
            @Override
            public View getView(int position, View convertView, android.view.ViewGroup parent)
            {
                return getStyledView(super.getView(position, convertView,parent));
            }
            
            private View getStyledView(View view)
            {
                TextView textView = (TextView)view.findViewById(android.R.id.text1);
                textView.setGravity(Gravity.CENTER);
                textView.setTextColor(R.color.ThemeLight);
                return view;
            }
            
        };
        adapter.insert(AccessPointInfo.DUMMY_VPN_PROFILE, 0);
        spin.setAdapter(adapter);

        String pn = currentNetwork.getVpnProfileName();
        int pos = adapter.getPosition(pn);
        if (pos < 0) {
            spin.setSelection(adapter.getPosition(AccessPointInfo.DUMMY_VPN_PROFILE));
        } else {
            spin.setSelection(pos);
        }

    }
    
    @Override
    protected void onVpnPermissionDenied(){
    }


}
