//
// Copyright 2017, 2018 Filippo "Fil" Bergamo <fil.bergamo@riseup.net>
// 
// This file is part of RepWifiApp.
//
// RepWifiApp is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// RepWifiApp is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with RepWifiApp.  If not, see <http://www.gnu.org/licenses/>.
// 
// ********************************************************************

package fil.libre.repwifiapp.activities;

import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import fil.libre.repwifiapp.ActivityLauncher;
import fil.libre.repwifiapp.R;
import fil.libre.repwifiapp.helpers.Logger;
import fil.libre.repwifiapp.network.ConnectionStatus;

public class ShowStatusActivity extends MenuEnabledActivity {

    private ConnectionStatus status;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_show_status);

        if (getIntent().hasExtra(ActivityLauncher.EXTRA_CONSTATUS)) {
            this.status = (ConnectionStatus) getIntent().getParcelableExtra(
                            ActivityLauncher.EXTRA_CONSTATUS);
        }

        try {
            showStatus();
        } catch (Exception e) {
            Logger.logError("Exception on showStatus", e);
        }

    }

    private void showStatus() {

        if (this.status != null) {

            String txt = getPrintableConnectionStatus(status);

            TextView t = (TextView) findViewById(R.id.txt_status);
            t.setText(txt);

        }

    }

    public void onBtnMainClick(View v) {
        finish();
    }

    public String getPrintableConnectionStatus(ConnectionStatus status) {

        if (status == null) {
            return "[NULL]";
        }

        String fmat = "%s: %s\n%s: %s\n%s: %s\n%s: %s\n%s: %s\n";

        return String.format(fmat, getString(R.string.text_ip_address), status.IP,
                        getString(R.string.text_subnet_mask), status.subnetMask,
                        getString(R.string.text_gateway), status.gateway,
                        getString(R.string.text_broadcast_address), status.broadcastAddress,
                        getString(R.string.text_hardware_address), status.hwAddress);

    }

}
