//
// Copyright 2017, 2018 Filippo "Fil" Bergamo <fil.bergamo@riseup.net>
// 
// This file is part of RepWifiApp.
//
// RepWifiApp is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// RepWifiApp is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with RepWifiApp.  If not, see <http://www.gnu.org/licenses/>.
// 
// ********************************************************************

package fil.libre.repwifiapp;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import fil.libre.repwifiapp.ActivityLauncher.RequestCode;
import fil.libre.repwifiapp.activities.MainActivity;
import fil.libre.repwifiapp.helpers.Logger;
import fil.libre.repwifiapp.service.ConnectionManagementService;

public class RepWifiIntentReceiver extends BroadcastReceiver {

    public void onReceive(Context context, Intent intent) {

        if (!Prefs.getBoolean(context, Prefs.PREF_AUTOSTART, false)) {
            return;
        }

        String a = intent.getAction();

        if (a.equals(Intent.ACTION_BOOT_COMPLETED) || a.equals(Intent.ACTION_REBOOT)) {
            Logger.logDebug("Starting on boot.", 100);
            startConnectionManagementService(context);
            launchRepWifiMainActivity(context, RequestCode.NONE);
        }

    }

    private void launchRepWifiMainActivity(Context context, int reqCode) {

        Intent intent = new Intent(context, MainActivity.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.addFlags(Intent.FLAG_ACTIVITY_NO_HISTORY);
        if (reqCode >= 0) {
            intent.putExtra(ActivityLauncher.EXTRA_REQCODE, reqCode);
        }
        context.startActivity(intent);

    }

    private void startConnectionManagementService(Context context) {
        Intent startIntent = new Intent(context, ConnectionManagementService.class);
        startIntent.setAction(ConnectionManagementService.ACTION_VOID);
        context.startService(startIntent);
    }

}
