//
// Copyright 2018 Filippo "Fil" Bergamo <fil.bergamo@riseup.net>
// 
// This file is part of RepWifiApp.
//
// RepWifiApp is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// RepWifiApp is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with RepWifiApp.  If not, see <http://www.gnu.org/licenses/>.
// 
// ********************************************************************
package fil.libre.repwifiapp;

import android.content.Context;
import android.content.SharedPreferences;

public class Prefs {

    public static final String PREF_MONITOR_NET_STATE = "monitor_connection";
    public static final String PREF_LOG_LEVEL = "debug_priority";
    public static final String PREF_DNS_1 = "dns1";
    public static final String PREF_DNS_2 = "dns2";
    public static final String PREF_AUTOSTART = "enable_autostart";
    public static final String PREF_PROGBAR = "enable_progbar";
    public static final String PREF_AUTOCONNECT = "enable_autoconnect";

    private static final String PREFS_FILENAME = "fil.libre.repwifiapp_preferences";

    public static int getLogPriority(Context c) {
        return Integer.parseInt(getPrefs(c).getString(PREF_LOG_LEVEL, "3"));
    }

    public static boolean isNetworkStateMonitoringEnabled(Context c) {
        return getPrefs(c).getBoolean(PREF_MONITOR_NET_STATE, false);
    }

    public static int getInt(Context c, String key, int defaultVal) {
        return getPrefs(c).getInt(key, defaultVal);
    }

    public static boolean getBoolean(Context c, String key, boolean defaultVal) {
        return getPrefs(c).getBoolean(key, defaultVal);
    }

    public static String getString(Context c, String key, String defaultVal) {
        return getPrefs(c).getString(key, defaultVal);
    }

    public static void commit(Context c) {
        getPrefs(c).edit().commit();
    }

    private static SharedPreferences getPrefs(Context c) {
        SharedPreferences prefs = c
                        .getSharedPreferences(PREFS_FILENAME, Context.MODE_MULTI_PROCESS);
        return prefs;
    }

}
