#!/bin/bash

#
# Copyright 2017-2018 Filippo "Fil" Bergamo <fil.bergamo@riseup.net>
# 
# This file is part of RepWifiApp.
#
# RepWifiApp is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# RepWifiApp is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with RepWifiApp.  If not, see <http:#www.gnu.org/licenses/>.
# 
# ********************************************************************

# ----------------------------------------------------------------------------
# This script copies the input APK into the /system/priv-app folder
# this makes the target App a system app, having system internal permissions.
#
# Input args: $1 = [destination-dir], $2=[source-file], $3=[system-partition]
#
# ----------------------------------------------------------------------------

LOG_TAG="RepWifi"
DESTDIR=$1
SRCAPK=$2
SYSPART=$3


function logE(){
    log -p e -t $LOG_TAG $1
}

function logD(){
    log -p d -t $LOG_TAG $1
}

# remounts /system readonly and restarts android's environment
# exits the script with the provided exit code $1
function finalize(){

    mount -o ro,remount "$SYSPART"
    start
    exit $1    

}

logD "Starting attempt to make myself a system app:"
logD "Source apk: $SRCAPK" 
logD "Destination dir: $DESTDIR"

# stop android's user shell to prevent userspace actions
# while the system partition is writeable:
stop

# mount /system partition read-write:
mount -o rw,remount $SYSPART

if [[ -e $DESTDIR ]]; then
    logD "Destination dir already exists."
else
    logD "Destination dir doesn't exist; creating it.."
    mkdir "$DESTDIR"

    if [[ $? != 0 ]]; then
         logE "FAILED to create destination dir"
         finalize 1
    fi
fi

# copy the source APK into the system apps' directory
logD "Copying apk.."
cp "$SRCAPK" "$DESTDIR"

if [[ $? == 0 ]]; then
    logD "Succeeded in making myself a system app!"
    finalize 0
else
    logE "Failed to make myself a system app!"
    finalize 2
fi

# just in case:
mount -o ro,remount "$SYSPART"
start

