package fil.libre.repwifiapp.helpers;


public abstract class WpaSupplicant {

    public static final String INTERFACE_NAME = "wlan0";
    public static final String WORKDIR = "/data/misc/wifi";
    public static final String PID_FILE = WORKDIR + "/pidfile";
    public static final String SOCKET_DIR = WORKDIR + "/sockets/";
    public static final String SOFTAP_FILE = WORKDIR + "/softap.conf";
    public static final String P2P_CONF = WORKDIR + "/p2p_supplicant.conf";
    public static final String WPA_CONF = WORKDIR + "/wpa_supplicant.conf";
    public static final String ENTROPY_FILE = WORKDIR + "/entropy.bin";
    public static final String OVERLAY_FILE = "/system/etc/wifi/wpa_supplicant_overlay.conf";

    protected static final String BASE_COMMNAD = "wpa_supplicant -B -dd -i" + INTERFACE_NAME + " -C" + SOCKET_DIR + " -P" + PID_FILE
                    + " -I" + OVERLAY_FILE + " -e" + ENTROPY_FILE;

    public static boolean start() {

        Utils.logDebug("startWpaSupplicant():");

        // needs root (for wpa_supplicant)
        if (RootCommand.executeRootCmd(BASE_COMMNAD)) {
            return true;
        } else {
            Utils.logDebug("Failed to start wpa");
            return false;
        }

    }

    public static boolean kill(){
        return RootCommand.executeRootCmd("killall -SIGINT wpa_supplicant");
    }
    
    public static boolean isRunning() {

        boolean retval = false;

        try {

            RootCommand su = new RootCommand("pidof wpa_supplicant");
            if (su.execute() == 0) {

                if (su.getOutput().trim().equals("")) {
                    retval = false;
                } else {
                    retval = true;
                }

            } else {
                retval = false;
            }

        } catch (Exception e) {
            Utils.logError("Exception during isWpaSupplicantRunning()", e);
            retval = false;
        }

        return retval;

    }

}
