package fil.libre.repwifiapp.helpers;

public abstract class WpaCli {

    private static final int SCAN_WAIT_INTERVAL = 3;
    private static final String BASE_COMMAND = "wpa_cli -p" + WpaSupplicant.SOCKET_DIR + " -P"
                    + WpaSupplicant.PID_FILE + " -i" + WpaSupplicant.INTERFACE_NAME;

    public static String createNetworkGetId() {

        try {

            RootCommand su = new RootCommand(BASE_COMMAND + " add_network");
            if (su.execute() == 0) {
                String out = su.getOutput();
                if (out == null || out.trim().equals("")) {
                    return null;
                } else {
                    return out.replace("\n", "");
                }
            } else {
                return null;
            }

        } catch (Exception e) {
            Utils.logError("Error while creating network", e);
            return null;
        }

    }

    public static boolean setNetworkSSID(String ssid, String networkID) {

        try {

            // needs root (wpa_cli)
            RootCommand su = new RootCommand(BASE_COMMAND + " set_network " + networkID
                            + " ssid '\"" + ssid + "\"'");
            if (su.execute() == 0) {
                String out = su.getOutput();
                if (out != null && out.trim().replace("\n", "").equals("OK")) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }

        } catch (Exception e) {
            Utils.logError("Error while setting network SSID", e);
            return false;
        }

    }

    public static boolean setNetworkPSK(AccessPointInfo info, String networkID) {

        try {

            // needs root (wpa_cli)

            String cmdSetPass = null;
            if (info.needsPassword()) {
                cmdSetPass = BASE_COMMAND + " set_network " + networkID + " psk '\""
                                + info.getPassword() + "\"'";
            } else {
                cmdSetPass = BASE_COMMAND + " set_network " + networkID + " key_mgmt NONE";
            }

            RootCommand su = new RootCommand(cmdSetPass);
            if (su.execute() == 0) {
                String out = su.getOutput();
                if (out != null && out.trim().replace("\n", "").equals("OK")) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }

        } catch (Exception e) {
            Utils.logError("Error while setting network PSK", e);
            return false;
        }

    }

    public static boolean setNetworkScanSSID(String networkID) {

        try {

            // needs root (wpa_cli)
            RootCommand su = new RootCommand(BASE_COMMAND + " set_network " + networkID
                            + " scan_ssid 1");
            if (su.execute() == 0) {
                String out = su.getOutput();
                if (out != null && out.trim().replace("\n", "").equals("OK")) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }

        } catch (Exception e) {
            Utils.logError("Error while setting network SSID", e);
            return false;
        }
    }

    public static boolean selectNetwork(String networkID) {

        try {

            // needs root (wpa_cli)
            RootCommand su = new RootCommand(BASE_COMMAND + " select_network " + networkID);
            if (su.execute() == 0) {
                String out = su.getOutput();
                if (out != null && out.trim().replace("\n", "").equals("OK")) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }

        } catch (Exception e) {
            Utils.logError("Error while selecting network", e);
            return false;
        }

    }

    public static boolean enableNetwork(String networkID) {

        try {

            // needs root (wpa_cli)

            RootCommand su = new RootCommand(BASE_COMMAND + " enable_network " + networkID);
            if (su.execute() == 0) {
                String out = su.getOutput();
                if (out != null && out.trim().replace("\n", "").equals("OK")) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }

        } catch (Exception e) {
            Utils.logError("Error while enabling network", e);
            return false;
        }

    }

    public static boolean scanNetworks() {

        // needs root (for wpa_supplicant and wpa_cli)
        return RootCommand.executeRootCmd(BASE_COMMAND
                        + " scan; if [ $? -ne 0 ]; then exit 1; fi; sleep " + SCAN_WAIT_INTERVAL);

    }

    public static String getScanResults() {

        try {

            RootCommand su = new RootCommand(BASE_COMMAND
                            + " scan_results; if [ $? -ne 0 ]; then exit 1; fi ");
            if (su.execute() == 0) {
                String out = su.getOutput();
                if (out == null || out.trim().equals("")) {
                    return null;
                } else {
                    return out;
                }
            } else {
                return null;
            }

        } catch (Exception e) {
            Utils.logError("Error while executing wpa_cli status", e);
            return null;
        }

        /*
         * // needs root (for wpa_supplicant and wpa_cli) boolean res =
         * RootCommand.executeRootCmd(); if (!res) { return false; } return res;
         */

    }

    /***
     * returns null if unable to determine connection status for any reason.
     */
    public static ConnectionStatus getConnectionStatus() {

        Utils.logDebug("called getConnecitonStatus()");
        if (!WpaSupplicant.isRunning()) {
            // wpa_supplicant is not running.
            // unable to determine status.
            Utils.logDebug("wpa not running, cannot get connection status.");
            return null;

        }

        try {

            RootCommand su = new RootCommand(BASE_COMMAND + " status");
            if (su.execute() == 0) {
                String out = su.getOutput();
                if (out == null || out.trim().equals("")) {
                    return null;
                } else {
                    return ConnectionStatus.parseWpaCliOutput(out);
                }
            } else {
                return null;
            }

        } catch (Exception e) {
            Utils.logError("Error while executing wpa_cli status", e);
            return null;
        }

    }

    public static boolean disconnect() {

        // needs root (for wpa_cli)

        if (!WpaSupplicant.isRunning()) {
            return true;
        }

        try {

            RootCommand su = new RootCommand(BASE_COMMAND + " disconnect");
            if (su.execute() == 0) {
                String out = su.getOutput();
                if (out != null && out.trim().replace("\n", "").equals("OK")) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }

        } catch (Exception e) {
            Utils.logError("Error while enabling network", e);
            return false;
        }
    }

}
