//
// Copyright 2017 Filippo "Fil" Bergamo <fil.bergamo@riseup.net>
// 
// This file is part of RepWifiApp.
//
// RepWifiApp is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// RepWifiApp is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with RepWifiApp.  If not, see <http://www.gnu.org/licenses/>.
// 
// ********************************************************************


package fil.libre.repwifiapp.activities;

import org.apache.http.conn.util.InetAddressUtils;
import java.util.List;
import fil.libre.repwifiapp.Commons;
import fil.libre.repwifiapp.R;
import fil.libre.repwifiapp.helpers.Utils;
import android.os.Bundle;
import android.preference.EditTextPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceFragment;

public class SettingsActivity extends PreferenceActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        setTheme(R.style.Theme_SettingsTheme);
        super.onCreate(savedInstanceState);
    }

    @Override
    public void onBuildHeaders(List<Header> target) {
        loadHeadersFromResource(R.xml.settings_headers, target);
    }

    public static class DebugSettingFragment extends PreferenceFragment {

        @Override
        public void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            addPreferencesFromResource(R.xml.debug_settings);

            setConfirmKillBackend();
            setDumpFileClick();

        }

        private void setConfirmKillBackend() {

            Preference pref = getPreferenceScreen().findPreference("pref_kill_backend");
            pref.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener() {

                @Override
                public boolean onPreferenceClick(Preference p) {
                    Commons.killBackEnd(getActivity(), false);
                    return true;
                }
            });

        }

        private void setDumpFileClick() {
            Preference pref = getPreferenceScreen().findPreference("pref_dump_log");
            pref.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener() {

                @Override
                public boolean onPreferenceClick(Preference p) {
                    if (Utils.dumpLogcatToFile(Commons.getLogDumpFile())) {
                        Commons.showMessage(getString(R.string.msg_log_saved) + ": \n" + Commons.getLogDumpFile(),
                                        getActivity());

                    } else {
                        Commons.showMessage(getString(R.string.msg_log_save_fail), getActivity());
                    }
                    return true;
                }
            });
        }

    }

    public static class GeneralSettingFragment extends PreferenceFragment {

        @Override
        public void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            addPreferencesFromResource(R.xml.general_settings);

            setValidationListener("dns1");
            setValidationListener("dns2");
            setConfirmRestore();

        }

        private void setValidationListener(String prefName) {
            EditTextPreference edit_Pref = (EditTextPreference) getPreferenceScreen()
                            .findPreference(prefName);

            edit_Pref.setOnPreferenceChangeListener(new Preference.OnPreferenceChangeListener() {

                @Override
                public boolean onPreferenceChange(Preference preference, Object newValue) {
                    // put validation here..
                    if (((String) newValue).isEmpty()
                                    || InetAddressUtils.isIPv4Address((String) newValue)) {
                        return true;
                    } else {
                        Commons.showMessage(getString(R.string.msg_error_ip_format), getActivity());
                        return false;
                    }
                }
            });
        }

        private void setConfirmRestore() {

            Preference pref = getPreferenceScreen().findPreference("pref_restore_default");
            pref.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener() {

                @Override
                public boolean onPreferenceClick(Preference p) {
                    Commons.resetSettingsDefault(getActivity(), false);
                    return true;
                }
            });

        }
    }

}
