## Contributing

### Report bugs

- Look at the [open and closed
  issues](https://github.com/vadret/android/issues?q=is%3Aissue) to see if
  this was not already discussed before. If you can't see any, feel free to
  [open a new issue](https://github.com/vadret/android/issues/new).

### Code Contribution

- Make sure to discuss your ideas with the community in an
  [issue](https://github.com/vadret/android/issues).
- Take a look at the open issues labeled as [`help wanted`](https://github.com/vadret/android/labels/help%20wanted)
  if you want to help without having a specific idea in mind.
- Make sure that your PRs do not contain unnecessary commits or merge commits.
  [Squash commits](https://git-scm.com/book/en/v2/Git-Tools-Rewriting-History)
  whenever possible.
- [Rebase](https://git-scm.com/book/en/v2/Git-Branching-Rebasing) (instead of
  merge) outdated PRs on the `dev` branch.
- Give extra care to your commit messages. Use the [imperative present
  tense](https://git-scm.com/book/ch5-2.html#Commit-Guidelines) and [follow Tim
  Pope's guidelines](http://tbaggery.com/2008/04/19/a-note-about-git-commit-messages.html).