package fi.kroon.vadret.util.extension

import org.threeten.bp.LocalDate
import org.threeten.bp.OffsetDateTime

fun String.Companion.empty(): String = ""
fun String.splitToList(): List<String> = this
    .split(",")
    .map { string ->
        String
        string.trim()
    }
    .filter { string ->
        string.isNotEmpty()
    }.toList()
fun String.parseToLocalDate(): LocalDate = OffsetDateTime.parse(this).toLocalDate()