// This software is released into the Public Domain by the author Victor H Olvera

package dudeofx.eval;

import android.app.Activity;
import android.os.Bundle;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.TextView.OnEditorActionListener;
import android.widget.ListView;
import android.view.View;
import java.util.List;
import java.io.File;
import java.lang.Double;
import android.widget.ArrayAdapter;
import android.view.KeyEvent;
import android.view.inputmethod.EditorInfo;
import android.view.View.OnKeyListener;
import android.widget.Toast;
import android.view.inputmethod.InputMethodManager;
import android.text.TextUtils;

//=================================================================================
public class EvalScreen extends Activity implements OnEditorActionListener {
   java.util.List<String> entry_list;
   tParseTree pt;
   int entry_count;
   //----------------------------------------------------------------------------
   @Override
   protected void onCreate(Bundle savedInstanceState) {
      super.onCreate(savedInstanceState);
      setContentView(R.layout.main);
      entry_list = new java.util.ArrayList<String>();

      EditText editText = (EditText) findViewById(R.id.entry_text_view);
      editText.setImeOptions(EditorInfo.IME_ACTION_DONE);
      editText.setOnEditorActionListener(this);

      ListView list = (ListView) findViewById(R.id.entry_list_view);
      list.setAdapter( new ArrayAdapter(this, R.layout.msg_item, entry_list) );
      list.setStackFromBottom(true);
      list.setTranscriptMode(ListView.TRANSCRIPT_MODE_ALWAYS_SCROLL);
      pt = new tParseTree();

      entry_list.add("enter 'help' for reference guide");
      entry_count = 1;
   }
   //----------------------------------------------------------------------------
   @Override
   public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
      if (actionId == EditorInfo.IME_ACTION_DONE) {
         EditText editText = (EditText) findViewById(R.id.entry_text_view);
         String entry = editText.getText().toString();
         editText.setText("");
         entry = entry.trim();

         if (entry.length() == 0) entry = "rep";   // everytime the user hits [Done] with no input it just repeats the last input

         entry_count++;
         pt.Parse(entry);
         tSyntaxNode tmp = pt.eval();
         String msg = "> " + pt.current_entry + "\n";
         do {
            if (tmp.type == tSyntaxNode.cVALUE) {
               msg += Double.toString(tmp.value);
            } else {
               msg += tmp.aux_msg;
            }    
            tmp = tmp.sibling;
            if (tmp != null) msg += ", ";
         } while (tmp != null);
         entry_list.add(msg);
         ListView list = (ListView) findViewById(R.id.entry_list_view);
         list.setSelection(entry_count - 1);

         return true;
      }
      return false;
   }
   //----------------------------------------------------------------------------
}
//=================================================================================

