package de.xskat;

public class Translations {
    // --------------------------------------------------------------------------------------
    // File text.c
    // --------------------------------------------------------------------------------------

    private final static String[][] TRANSLATIONS = { // DE, EN
            {"Null", "Null"}, // XT_Null
            {"Karo", "Diamond"}, // XT_Karo
            {"Herz", "Heart"}, // XT_Herz
            {"Pik", "Spade"}, // XT_Pik
            {"Kreuz", "Club"}, // XT_Kreuz
            {"Grand", "Grand"}, // XT_Grand
            {"Ramsch", "Ramsch"}, // XT_Ramsch
            {"Sortiere für Null", "Sort for Null"}, // XT_Sortiere_fuer_Null
            {"Sortiere normal", "Sort normally"}, // XT_Sortiere_normal
            {"Gereizt bis", "It was bid"}, // XT_Gereizt_bis
            {"Androido", "Androido"}, // XT_Androido
            {"Androida", "Androida"}, // XT_Androida
            {"spielt", "plays"}, // XT_spielt
            {"Hand", "Hand"}, // XT_Hand
            {"für", "for"}, // XT_fuer
            {"Spitze", "Spitze"}, // XT_Spitze
            {"Annehmen", "Accept"}, // XT_Annehmen
            {"Schenken", "Concede"}, // XT_Schenken
            {"Passe", "Pass"}, // XT_Passe
            {"Im Skat", "Skat"}, // XT_Im_Skat
            {"war", "was"}, // XT_war
            {"ist", "is"}, // XT_ist
            {"Eine Jungfrau!", "One virgin!"}, // XT_Eine_Jungfrau
            {"Durchmarsch!", "Forced march!"}, // XT_Durchmarsch
            {"Überreizt!", "Overbid!"}, // XT_Ueberreizt
            {"Gegner nicht Schneider!", "Opponents not Schneider!"}, // XT_Gegner_nicht_Schneider
            {"Gegner nicht schwarz!", "Opponents not schwarz!"}, // XT_Gegner_nicht_schwarz
            {"Spitze verloren!", "Lost Spitze!"}, // XT_Spitze_verloren
            {"Spieler", "Player"}, // XT_Spieler
            {"Niemand", "Nobody"}, // XT_Niemand
            {"gewinnt", "wins"}, // XT_gewinnt
            {"verliert", "loses"}, // XT_verliert
            {"das Nullspiel.", "the Null game."}, // XT_das_Nullspiel
            {"den Ramsch.", "the Ramsch."}, // XT_den_Ramsch
            {"schwarz.", "schwarz."}, // XT_schwarz
            {"mit", "with"}, // XT_mit
            {"Augen.", "points."}, // XT_Augen
            {"Spielwert", "Game value"}, // XT_Spielwert
            {"Ja", "Yes"}, // XT_Ja
            {"Weiter", "Continue"}, // XT_Weiter
            {"Dieses Programm ist freie Software;",
                    "This program is free software;"}, // XT_Dieses_Programm_ist_freie_Software
            {"es kann frei verbreitet werden.",
                    "you can redistribute it freely."}, // XT_es_kann_frei_verbreitet_werden
            {"Nur bei Handspielen kann Schneider",
                    "Only when playing Hand you may"}, // XT_Nur_bei_Handspielen_kann_Schneider
            {"oder schwarz angesagt werden.", "say Schneider or schwarz."}, // XT_oder_schwarz_angesagt_werden
            {"Ouvert schließt schwarz angesagt ein", "Ouvert includes schwarz"}, // XT_Ouvert_schliesst_schwarz_angesagt_ein
            {"(außer bei Null natürlich).", "(except when playing Null)."}, // XT_ausser_bei_Null_natuerlich
            {"Hand?", "Hand?"}, // XT_HandFrage
            {"Nein", "No"}, // XT_Nein
            {"Spiel", "Game"}, // XT_Spiel
            {"G/V", "W/L"}, // XT_GV
            {"Löschen", "Delete"}, // XT_Loeschen
            {"Über XSkat", "About XSkat"}, // XT_Ueber_XSkat
            {"Optionen", "Options"}, // XT_Optionen
            {"Letzter Stich", "Last trick"}, // XT_Letzter_Stich
            {"Lösche", "Delete"}, // XT_Loesche
            {"Spielstand", "game score"}, // XT_Spielstand
            {"und Liste?", "and list?"}, // XT_und_Liste
            {"Liste", "List"}, // XT_Liste
            {"Protokoll", "Log"}, // XT_Protokoll
            {"Schneider", "Schneider"}, // XT_Schneider
            {"Schwarz", "Schwarz"}, // XT_Schwarz
            {"Ouvert", "Ouvert"}, // XT_Ouvert
            {"Spielen", "Play"}, // XT_Spielen
            {"Revolution", "Revolution"}, // XT_Revolution
            {"Du hast höher gereizt als der", "The value of your game"}, // XT_Du_hast_hoeher_gereizt_als_der
            {"Wert des angesagten Spiels!", "is not high enough!"}, // XT_Wert_des_angesagten_Spiels
            {"Null: 23, Hand: 35", "Null: 23, Hand: 35"}, // XT_Null_23_Hand_35
            {"ouvert: 46, ouvert Hand: 59", "ouvert: 46, ouvert Hand: 59"}, // XT_ouvert_46_ouvert_Hand_59
            {"Revolution: 92", "Revolution: 92"}, // XT_Revolution_92
            {"Drücken", "Done"}, // XT_Druecken
            {"Fertig", "Done"}, // XT_Fertig
            {"Spielstärke", "Playing strength"}, // XT_Spielstaerke
            {"Sprache", "Language"}, // XT_Sprache
            {"Display irgendwo antippen,", "Tap screen anywhere"}, // XT_Display_irgendwo_antippen
            {"um Stich zu entfernen.", "to remove trick."}, // XT_um_Stich_zu_entfernen
            {"Neues Spiel", "New game"}, // XT_NeuesSpiel
            {"http://xskat.de/android-de.html", "http://xskat.de/android.html"}, // XT_xskat_de
            {"Blatt", "Suit"}, // XT_Blatt
            {"Turnier", "Tournament"}, // XT_Turnier
            {"Französisch", "French"}, // XT_Franzoesisch
            {"Deutsch", "German"}, // XT_Deutsch
            {"Schellen", "Bells"}, // XT_Schellen
            {"Rot", "Hearts"}, // XT_Rot
            {"Grün", "Leaves"}, // XT_Gruen
            {"Eicheln", "Acorns"}, // XT_Eicheln
            {"Sortierung", "Sort"}, // XT_Sortierung
            {"Alternierend", "Alternating"}, // XT_Alternierend
            {"Sequentiell", "Sequential"}, // XT_Sequentiell
            {"Nimm Stich nach", "Take trick after"}, // XT_Nimm_Stich_nach
            {"Antippen.", "tapping."}, // XT_Antippen
            {" Sekunden.", " seconds."}, // XT_Sekunden
            {"Varianten", "Variants"}, // XT_Varianten
            {"Immer", "Always"}, // XT_Immer
            {"Kontra", "Kontra"}, // XT_Kontra
            {"ab 18", "if 18"}, // XT_Ab_18
            {"Bock", "Bock"}, // XT_Bock
            {"+Ramsch", "+Ramsch"}, // XT_Plus_Ramsch
            {"zählt 2", "counts 2"}, // XT_Zaehlt_2
            {"Schieberamsch", "Schieberamsch"}, // XT_Schieberamsch
            {"Skat geht an", "Skat goes to"}, // XT_Skat_geht_an
            {"letzten Stich", "last trick"}, // XT_letzten_Stich
            {"Verlierer", "loser"}, // XT_Verlierer
            {"Skat aufnehmen?", "Pick up Skat?"}, // XT_Skat_aufnehmen
            {"Spielwert verdoppelt!", "Game value doubled!"}, // XT_Spielwert_verdoppelt
            {"nimmt den Skat nicht auf.", "doesn't pick up the Skat."}, // XT_nimmt_den_Skat_nicht_auf
            {"klopft.", "knocks."}, // XT_klopft
            {"Klopfen", "Klopfen"}, // XT_Klopfen
            {"Spielwert verdoppeln?", "Double game value?"}, // XT_Spielwert_verdoppeln
            {"Buben", "Buben"}, // XT_Buben
            {"Jacks", "Jacks"}, // XT_Jacks
            {"Unter", "Unter"}, // XT_Unter
            {"dürfen nicht geschoben werden.", "may not be passed on."}, // XT_duerfen_nicht_geschoben_werden
            {"Re", "Re"}, // XT_Re
            {"von ", "by "}, // XT_von
            {"mit Kontra", "with Kontra"}, // XT_mit_Kontra
            {" & ", " & "}, // XT_und
            {"Vorschläge", "Hints"}, // XT_Vorschlaege
            {"Nochmal", "Replay"}, // XT_Nochmal
            {"Spiel wiederholen", "Replay game"}, // XT_Spiel_wiederholen
            {"mit den Karten von", "with the cards from"}, // XT_mit_den_Karten_von
            {"mir", "me"}, // XT_mir
            {"Zurück", "Back"}, // XT_Zurueck
            {"Start", "Start"}, // XT_Start
            {"Animationsgeschwindigkeit", "Animation speed"}, // XT_AnimationSpeed
            {"https://github.com/rnauber/xskat-android", "https://github.com/rnauber/xskat-android"} // XT_github_xskat / 124
    };

    static final int XT_Null = 0;
    static final int XT_Karo = 1;
    static final int XT_Herz = 2;
    static final int XT_Pik = 3;
    static final int XT_Kreuz = 4;
    static final int XT_Grand = 5;
    static final int XT_Ramsch = 6;
    static final int XT_Sortiere_fuer_Null = 7;
    static final int XT_Sortiere_normal = 8;
    static final int XT_Gereizt_bis = 9;
    static final int XT_Androido = 10;
    static final int XT_Androida = 11;
    static final int XT_spielt = 12;
    static final int XT_Hand = 13;
    static final int XT_fuer = 14;
    static final int XT_Spitze = 15;
    static final int XT_Annehmen = 16;
    static final int XT_Schenken = 17;
    static final int XT_Passe = 18;
    static final int XT_Im_Skat = 19;
    static final int XT_war = 20;
    static final int XT_ist = 21;
    static final int XT_Eine_Jungfrau = 22;
    static final int XT_Durchmarsch = 23;
    static final int XT_Ueberreizt = 24;
    static final int XT_Gegner_nicht_Schneider = 25;
    static final int XT_Gegner_nicht_schwarz = 26;
    static final int XT_Spitze_verloren = 27;
    static final int XT_Spieler = 28;
    static final int XT_Niemand = 29;
    static final int XT_gewinnt = 30;
    static final int XT_verliert = 31;
    static final int XT_das_Nullspiel = 32;
    static final int XT_den_Ramsch = 33;
    static final int XT_schwarz = 34;
    static final int XT_mit = 35;
    static final int XT_Augen = 36;
    static final int XT_Spielwert = 37;
    static final int XT_Ja = 38;
    static final int XT_Weiter = 39;
    static final int XT_Dieses_Programm_ist_freie_Software = 40;
    static final int XT_es_kann_frei_verbreitet_werden = 41;
    static final int XT_Nur_bei_Handspielen_kann_Schneider = 42;
    static final int XT_oder_schwarz_angesagt_werden = 43;
    static final int XT_Ouvert_schliesst_schwarz_angesagt_ein = 44;
    static final int XT_ausser_bei_Null_natuerlich = 45;
    static final int XT_HandFrage = 46;
    static final int XT_Nein = 47;
    static final int XT_Spiel = 48;
    static final int XT_GV = 49;
    static final int XT_Loeschen = 50;
    static final int XT_Ueber_XSkat = 51;
    static final int XT_Optionen = 52;
    static final int XT_Letzter_Stich = 53;
    static final int XT_Loesche = 54;
    static final int XT_Spielstand = 55;
    static final int XT_und_Liste = 56;
    static final int XT_Liste = 57;
    static final int XT_Protokoll = 58;
    static final int XT_Schneider = 59;
    static final int XT_Schwarz = 60;
    static final int XT_Ouvert = 61;
    static final int XT_Spielen = 62;
    static final int XT_Revolution = 63;
    static final int XT_Du_hast_hoeher_gereizt_als_der = 64;
    static final int XT_Wert_des_angesagten_Spiels = 65;
    static final int XT_Null_23_Hand_35 = 66;
    static final int XT_ouvert_46_ouvert_Hand_59 = 67;
    static final int XT_Revolution_92 = 68;
    static final int XT_Druecken = 69;
    static final int XT_Fertig = 70;
    static final int XT_Spielstaerke = 71;
    static final int XT_Sprache = 72;
    static final int XT_Display_irgendwo_antippen = 73;
    static final int XT_um_Stich_zu_entfernen = 74;
    static final int XT_NeuesSpiel = 75;
    static final int XT_xskat_de = 76;
    static final int XT_Blatt = 77;
    static final int XT_Turnier = 78;
    static final int XT_Franzoesisch = 79;
    static final int XT_Deutsch = 80;
    static final int XT_Schellen = 81;
    static final int XT_Rot = 82;
    static final int XT_Gruen = 83;
    static final int XT_Eicheln = 84;
    static final int XT_Sortierung = 85;
    static final int XT_Alternierend = 86;
    static final int XT_Sequentiell = 87;
    static final int XT_Nimm_Stich_nach = 88;
    static final int XT_Antippen = 89;
    static final int XT_Sekunden = 90;
    static final int XT_Varianten = 91;
    static final int XT_Immer = 92;
    static final int XT_Kontra = 93;
    static final int XT_Ab_18 = 94;
    static final int XT_Bock = 95;
    static final int XT_Plus_Ramsch = 96;
    static final int XT_Zaehlt_2 = 97;
    static final int XT_Schieberamsch = 98;
    static final int XT_Skat_geht_an = 99;
    static final int XT_letzten_Stich = 100;
    static final int XT_Verlierer = 101;
    static final int XT_Skat_aufnehmen = 102;
    static final int XT_Spielwert_verdoppelt = 103;
    static final int XT_nimmt_den_Skat_nicht_auf = 104;
    static final int XT_klopft = 105;
    static final int XT_Klopfen = 106;
    static final int XT_Spielwert_verdoppeln = 107;
    static final int XT_Buben = 108;
    static final int XT_Jacks = 109;
    static final int XT_Unter = 110;
    static final int XT_duerfen_nicht_geschoben_werden = 111;
    static final int XT_Re = 112;
    static final int XT_von = 113;
    static final int XT_mit_Kontra = 114;
    static final int XT_und = 115;
    static final int XT_Vorschlaege = 116;
    static final int XT_Nochmal = 117;
    static final int XT_Spiel_wiederholen = 118;
    static final int XT_mit_den_Karten_von = 119;
    static final int XT_mir = 120;
    static final int XT_Zurueck = 121;
    static final int XT_Start = 122;
    static final int XT_AnimationSpeed = 123;
    static final int XT_github_xskat = 124;

    static String getTranslation(int key, int currentLanguage) {
        return TRANSLATIONS[key][currentLanguage];
    }
}
