/*
 * Copyright 2017 Juergen Fickel
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.retujo.java.util;

/**
 * This interface represents a provider of results. It is not prescribed that the results must vary for each
 * invocation of the Provider.
 *
 * @param <T> the type of the results this Provider returns.
 *
 * @since 1.0.0
 */
@SuppressWarnings("squid:S1609")
public interface Provider<T> {

    /**
     * Returns the result.
     *
     * @return the result;
     */
    T get();

}
